/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.permadmin;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.internal.permadmin.BundlePermissions;
import org.eclipse.osgi.internal.permadmin.PermissionInfoCollection;
import org.eclipse.osgi.internal.permadmin.SecurityAdmin;
import org.eclipse.osgi.internal.permadmin.SecurityRowSnapShot;
import org.osgi.framework.Bundle;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.permissionadmin.PermissionInfo;

public final class SecurityRow
implements ConditionalPermissionInfo {
    static final Class<?>[] conditionMethodArgs = new Class[]{Bundle.class, ConditionInfo.class};
    static Condition[] ABSTAIN_LIST = new Condition[0];
    static Condition[] SATISFIED_LIST = new Condition[0];
    static final Decision DECISION_ABSTAIN = new Decision(4, null, null, null);
    static final Decision DECISION_GRANTED = new Decision(1, null, null, null);
    static final Decision DECISION_DENIED = new Decision(2, null, null, null);
    private final SecurityAdmin securityAdmin;
    private final String name;
    private final ConditionInfo[] conditionInfos;
    private final PermissionInfoCollection permissionInfoCollection;
    private final boolean deny;
    final Map<BundlePermissions, Condition[]> bundleConditions;

    public SecurityRow(SecurityAdmin securityAdmin, String name, ConditionInfo[] conditionInfos, PermissionInfo[] permissionInfos, String decision) {
        boolean a;
        if (permissionInfos == null || permissionInfos.length == 0) {
            throw new IllegalArgumentException("It is invalid to have empty permissionInfos");
        }
        this.securityAdmin = securityAdmin;
        this.conditionInfos = conditionInfos == null ? new ConditionInfo[]{} : conditionInfos;
        boolean d = "deny".equals(decision = decision.toLowerCase());
        if (!(d | (a = "allow".equals(decision)))) {
            throw new IllegalArgumentException("Invalid decision: " + decision);
        }
        this.deny = d;
        this.name = name;
        this.permissionInfoCollection = new PermissionInfoCollection(permissionInfos);
        this.bundleConditions = conditionInfos == null || conditionInfos.length == 0 ? null : new HashMap<BundlePermissions, Condition[]>();
    }

    static SecurityRowSnapShot createSecurityRowSnapShot(String encoded) {
        return (SecurityRowSnapShot)SecurityRow.createConditionalPermissionInfo(null, encoded);
    }

    static SecurityRow createSecurityRow(SecurityAdmin securityAdmin, String encoded) {
        return (SecurityRow)SecurityRow.createConditionalPermissionInfo(securityAdmin, encoded);
    }

    private static ConditionalPermissionInfo createConditionalPermissionInfo(SecurityAdmin securityAdmin, String encoded) {
        int start;
        int end;
        if ((encoded = encoded.trim()).length() == 0) {
            throw new IllegalArgumentException("Empty encoded string is invalid");
        }
        char[] chars = encoded.toCharArray();
        char lastChar = chars[end = encoded.length() - 1];
        if (lastChar != '}' && lastChar != '\"') {
            throw new IllegalArgumentException(encoded);
        }
        String encodedName = null;
        if (lastChar == '\"') {
            int startName;
            if (chars.length < 2) {
                throw new IllegalArgumentException(encoded);
            }
            int endName = encoded.length() - 1;
            for (startName = endName - 1; startName > 0; --startName) {
                if (chars[startName] != '\"') continue;
                if (--startName > 0 && chars[startName] == '\\') {
                    --startName;
                    continue;
                }
                ++startName;
                break;
            }
            if (chars[startName] != '\"') {
                throw new IllegalArgumentException(encoded);
            }
            encodedName = SecurityRow.unescapeString(encoded.substring(startName + 1, endName));
            end = encoded.lastIndexOf(125, startName);
        }
        if ((start = encoded.indexOf(123)) < 0 || end < start) {
            throw new IllegalArgumentException(encoded);
        }
        String decision = encoded.substring(0, start);
        if ((decision = decision.trim()).length() == 0 || !"deny".equalsIgnoreCase(decision) && !"allow".equalsIgnoreCase(decision)) {
            throw new IllegalArgumentException(encoded);
        }
        ArrayList<ConditionInfo> condList = new ArrayList<ConditionInfo>();
        ArrayList<PermissionInfo> permList = new ArrayList<PermissionInfo>();
        for (int pos = start + 1; pos < end; ++pos) {
            char endChar;
            while (pos < end && chars[pos] != '[' && chars[pos] != '(') {
                ++pos;
            }
            if (pos == end) break;
            int startPos = pos;
            char c = endChar = chars[startPos] == '[' ? (char)']' : ')';
            while (pos < end && chars[pos] != endChar) {
                if (chars[pos] == '\"') {
                    ++pos;
                    while (chars[pos] != '\"') {
                        if (chars[pos] == '\\') {
                            ++pos;
                        }
                        ++pos;
                    }
                }
                ++pos;
            }
            int endPos = pos;
            String token = new String(chars, startPos, endPos - startPos + 1);
            if (endChar == ']') {
                condList.add(new ConditionInfo(token));
                continue;
            }
            permList.add(new PermissionInfo(token));
        }
        if (permList.size() == 0) {
            throw new IllegalArgumentException("No Permission infos: " + encoded);
        }
        ConditionInfo[] conds = condList.toArray(new ConditionInfo[condList.size()]);
        PermissionInfo[] perms = permList.toArray(new PermissionInfo[permList.size()]);
        if (securityAdmin == null) {
            return new SecurityRowSnapShot(encodedName, conds, perms, decision);
        }
        return new SecurityRow(securityAdmin, encodedName, conds, perms, decision);
    }

    static Object cloneArray(Object[] array) {
        if (array == null) {
            return null;
        }
        Object result = Array.newInstance(array.getClass().getComponentType(), array.length);
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    private static void escapeString(String str, StringBuffer output) {
        int len = str.length();
        block5: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    output.append('\\');
                    output.append(c);
                    continue block5;
                }
                case '\r': {
                    output.append("\\r");
                    continue block5;
                }
                case '\n': {
                    output.append("\\n");
                    continue block5;
                }
                default: {
                    output.append(c);
                }
            }
        }
    }

    private static String unescapeString(String str) {
        StringBuffer output = new StringBuffer(str.length());
        int end = str.length();
        for (int i = 0; i < end; ++i) {
            int c = str.charAt(i);
            if (c == 92 && ++i < end) {
                c = str.charAt(i);
                switch (c) {
                    case 34: 
                    case 92: {
                        break;
                    }
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 110: {
                        c = 10;
                        break;
                    }
                    default: {
                        c = 92;
                        --i;
                    }
                }
            }
            output.append((char)c);
        }
        return output.toString();
    }

    public String getName() {
        return this.name;
    }

    public ConditionInfo[] getConditionInfos() {
        return (ConditionInfo[])SecurityRow.cloneArray(this.conditionInfos);
    }

    ConditionInfo[] internalGetConditionInfos() {
        return this.conditionInfos;
    }

    public String getAccessDecision() {
        return this.deny ? "deny" : "allow";
    }

    public PermissionInfo[] getPermissionInfos() {
        return (PermissionInfo[])SecurityRow.cloneArray(this.permissionInfoCollection.getPermissionInfos());
    }

    PermissionInfo[] internalGetPermissionInfos() {
        return this.permissionInfoCollection.getPermissionInfos();
    }

    public void delete() {
        this.securityAdmin.delete(this, true);
    }

    Condition[] getConditions(Bundle bundle) {
        Condition[] conditions = new Condition[this.conditionInfos.length];
        for (int i = 0; i < this.conditionInfos.length; ++i) {
            Class<?> clazz;
            try {
                clazz = Class.forName(this.conditionInfos[i].getType());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            Constructor<?> constructor = null;
            Method method = null;
            try {
                method = clazz.getMethod("getCondition", conditionMethodArgs);
                if ((method.getModifiers() & 8) == 0) {
                    method = null;
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (method == null) {
                try {
                    constructor = clazz.getConstructor(conditionMethodArgs);
                }
                catch (NoSuchMethodException e) {
                    conditions[i] = Condition.FALSE;
                    continue;
                }
            }
            Object[] args = new Object[]{bundle, this.conditionInfos[i]};
            try {
                if (method != null) {
                    conditions[i] = (Condition)method.invoke(null, args);
                    continue;
                }
                conditions[i] = (Condition)constructor.newInstance(args);
                continue;
            }
            catch (Throwable t) {
                conditions[i] = Condition.FALSE;
            }
        }
        return conditions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    Decision evaluate(BundlePermissions bundlePermissions, Permission permission) {
        if (this.bundleConditions == null) return this.evaluatePermission(permission);
        if (bundlePermissions == null) {
            return this.evaluatePermission(permission);
        }
        Map<BundlePermissions, Condition[]> map = this.bundleConditions;
        // MONITORENTER : map
        Condition[] conditions = this.bundleConditions.get(bundlePermissions);
        if (conditions == null) {
            conditions = this.getConditions(bundlePermissions.getBundle());
            this.bundleConditions.put(bundlePermissions, conditions);
        }
        // MONITOREXIT : map
        if (conditions == ABSTAIN_LIST) {
            return DECISION_ABSTAIN;
        }
        if (conditions == SATISFIED_LIST) {
            return this.evaluatePermission(permission);
        }
        boolean empty = true;
        ArrayList<Condition> postponedConditions = null;
        Decision postponedPermCheck = null;
        for (int i = 0; i < conditions.length; ++i) {
            Condition condition = conditions[i];
            if (condition == null) continue;
            if (!this.isPostponed(condition)) {
                boolean mutable = condition.isMutable();
                if (!condition.isSatisfied()) {
                    if (mutable) return DECISION_ABSTAIN;
                    Map<BundlePermissions, Condition[]> map2 = this.bundleConditions;
                    // MONITORENTER : map2
                    this.bundleConditions.put(bundlePermissions, ABSTAIN_LIST);
                    // MONITOREXIT : map2
                    return DECISION_ABSTAIN;
                }
                if (!mutable) {
                    conditions[i] = null;
                }
            } else {
                if (postponedPermCheck == null) {
                    postponedPermCheck = this.evaluatePermission(permission);
                }
                if (postponedPermCheck == DECISION_ABSTAIN) {
                    return postponedPermCheck;
                }
                if (postponedConditions == null) {
                    postponedConditions = new ArrayList<Condition>(1);
                }
                postponedConditions.add(condition);
            }
            empty &= conditions[i] == null;
        }
        if (empty) {
            Map<BundlePermissions, Condition[]> map3 = this.bundleConditions;
            // MONITORENTER : map3
            this.bundleConditions.put(bundlePermissions, SATISFIED_LIST);
            // MONITOREXIT : map3
        }
        if (postponedPermCheck == null) return this.evaluatePermission(permission);
        return new Decision(postponedPermCheck.decision | 8, postponedConditions.toArray(new Condition[postponedConditions.size()]), this, bundlePermissions);
    }

    private boolean isPostponed(Condition condition) {
        return condition.isPostponed() && this.securityAdmin.getSupportedSecurityManager() != null;
    }

    private Decision evaluatePermission(Permission permission) {
        return this.permissionInfoCollection.implies(permission) ? (this.deny ? DECISION_DENIED : DECISION_GRANTED) : DECISION_ABSTAIN;
    }

    public String toString() {
        return this.getEncoded();
    }

    public String getEncoded() {
        return SecurityRow.getEncoded(this.name, this.conditionInfos, this.internalGetPermissionInfos(), this.deny);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ConditionalPermissionInfo)) {
            return false;
        }
        return this.getEncoded().equals(((ConditionalPermissionInfo)obj).getEncoded());
    }

    public int hashCode() {
        return SecurityRow.getHashCode(this.name, this.internalGetConditionInfos(), this.internalGetPermissionInfos(), this.getAccessDecision());
    }

    static int getHashCode(String name, ConditionInfo[] conds, PermissionInfo[] perms, String decision) {
        int i;
        int h = 527 + decision.hashCode();
        for (i = 0; i < conds.length; ++i) {
            h = 31 * h + conds[i].hashCode();
        }
        for (i = 0; i < perms.length; ++i) {
            h = 31 * h + perms[i].hashCode();
        }
        if (name != null) {
            h = 31 * h + name.hashCode();
        }
        return h;
    }

    static String getEncoded(String name, ConditionInfo[] conditionInfos, PermissionInfo[] permissionInfos, boolean deny) {
        int i;
        StringBuffer result = new StringBuffer();
        if (deny) {
            result.append("deny");
        } else {
            result.append("allow");
        }
        result.append(" { ");
        if (conditionInfos != null) {
            for (i = 0; i < conditionInfos.length; ++i) {
                result.append(conditionInfos[i].getEncoded()).append(' ');
            }
        }
        if (permissionInfos != null) {
            for (i = 0; i < permissionInfos.length; ++i) {
                result.append(permissionInfos[i].getEncoded()).append(' ');
            }
        }
        result.append('}');
        if (name != null) {
            result.append(" \"");
            SecurityRow.escapeString(name, result);
            result.append('\"');
        }
        return result.toString();
    }

    PermissionInfoCollection getPermissionInfoCollection() {
        return this.permissionInfoCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCaches() {
        this.permissionInfoCollection.clearPermissionCache();
        if (this.bundleConditions != null) {
            Map<BundlePermissions, Condition[]> map = this.bundleConditions;
            synchronized (map) {
                this.bundleConditions.clear();
            }
        }
    }

    static class Decision {
        final int decision;
        final Condition[] postponed;
        private final SecurityRow row;
        private final BundlePermissions bundlePermissions;

        Decision(int decision, Condition[] postponed, SecurityRow row, BundlePermissions bundlePermissions) {
            this.decision = decision;
            this.postponed = postponed;
            this.row = row;
            this.bundlePermissions = bundlePermissions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleImmutable(Condition condition, boolean isSatisfied, boolean mutable) {
            if (mutable || !condition.isPostponed()) {
                return;
            }
            if (isSatisfied) {
                Map<BundlePermissions, Condition[]> map = this.row.bundleConditions;
                synchronized (map) {
                    Condition[] rowConditions = this.row.bundleConditions.get(this.bundlePermissions);
                    boolean isEmpty = true;
                    for (int i = 0; i < rowConditions.length; ++i) {
                        if (rowConditions[i] == condition && isSatisfied) {
                            rowConditions[i] = null;
                        }
                        isEmpty &= rowConditions[i] == null;
                    }
                    if (isEmpty) {
                        this.row.bundleConditions.put(this.bundlePermissions, SATISFIED_LIST);
                    }
                }
            }
            Map<BundlePermissions, Condition[]> map = this.row.bundleConditions;
            synchronized (map) {
                this.row.bundleConditions.put(this.bundlePermissions, ABSTAIN_LIST);
            }
        }
    }
}

