/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.signedcontent;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.internal.hookregistry.StorageHookFactory;
import org.eclipse.osgi.internal.signedcontent.PKCS7Processor;
import org.eclipse.osgi.internal.signedcontent.SignedContentImpl;
import org.eclipse.osgi.internal.signedcontent.SignerInfoImpl;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.storage.BundleInfo;
import org.osgi.framework.BundleException;

public class SignedStorageHook
extends StorageHookFactory<List<SignerInfo>, List<SignerInfo>, StorageHookImpl> {
    private static final int STORAGE_VERSION = 4;

    @Override
    public int getStorageVersion() {
        return 4;
    }

    @Override
    public List<SignerInfo> createSaveContext() {
        return new ArrayList<SignerInfo>();
    }

    @Override
    public List<SignerInfo> createLoadContext(int version) {
        return new ArrayList<SignerInfo>();
    }

    @Override
    protected StorageHookImpl createStorageHook(BundleInfo.Generation generation) {
        return new StorageHookImpl(generation);
    }

    static class StorageHookImpl
    extends StorageHookFactory.StorageHook<List<SignerInfo>, List<SignerInfo>> {
        SignedContentImpl signedContent;

        public StorageHookImpl(BundleInfo.Generation generation) {
            super(generation, SignedStorageHook.class);
        }

        @Override
        public void initialize(Dictionary<String, String> manifest) throws BundleException {
        }

        @Override
        public void load(List<SignerInfo> loadContext, DataInputStream is) throws IOException {
            boolean signed = is.readBoolean();
            if (!signed) {
                return;
            }
            int numSigners = is.readInt();
            SignerInfo[] signerInfos = new SignerInfo[numSigners];
            for (int i = 0; i < numSigners; ++i) {
                signerInfos[i] = this.readSignerInfo(is, loadContext);
            }
            int resultsSize = is.readInt();
            HashMap<String, Object> contentMDResults = null;
            if (resultsSize > 0) {
                contentMDResults = new HashMap<String, Object>(resultsSize);
                for (int i = 0; i < resultsSize; ++i) {
                    String path = is.readUTF();
                    int numEntrySigners = is.readInt();
                    SignerInfo[] entrySigners = new SignerInfo[numEntrySigners];
                    byte[][] entryResults = new byte[numEntrySigners][];
                    for (int j = 0; j < numEntrySigners; ++j) {
                        entrySigners[j] = this.readSignerInfo(is, loadContext);
                        int resultSize = is.readInt();
                        entryResults[j] = new byte[resultSize];
                        is.readFully(entryResults[j]);
                    }
                    contentMDResults.put(path, new Object[]{entrySigners, entryResults});
                }
            }
            SignedContentImpl result = new SignedContentImpl(signerInfos, contentMDResults);
            for (int i = 0; i < numSigners; ++i) {
                boolean hasTSA = is.readBoolean();
                if (!hasTSA) continue;
                SignerInfo tsaSigner = this.readSignerInfo(is, loadContext);
                Date signingDate = new Date(is.readLong());
                result.addTSASignerInfo(signerInfos[i], tsaSigner, signingDate);
            }
            this.signedContent = result;
        }

        private SignerInfo readSignerInfo(DataInputStream is, List<SignerInfo> loadContext) throws IOException {
            int index = is.readInt();
            if (index >= 0) {
                return loadContext.get(index);
            }
            int numCerts = is.readInt();
            Certificate[] certs = new Certificate[numCerts];
            for (int i = 0; i < numCerts; ++i) {
                int certSize = is.readInt();
                byte[] certBytes = new byte[certSize];
                is.readFully(certBytes);
                try {
                    certs[i] = PKCS7Processor.certFact.generateCertificate(new ByteArrayInputStream(certBytes));
                    continue;
                }
                catch (CertificateException e) {
                    throw (IOException)new IOException(e.getMessage()).initCause(e);
                }
            }
            int anchorIdx = is.readInt();
            SignerInfoImpl result = new SignerInfoImpl(certs, anchorIdx >= 0 ? certs[anchorIdx] : null, is.readUTF());
            loadContext.add(result);
            return result;
        }

        @Override
        public void save(List<SignerInfo> saveContext, DataOutputStream os) throws IOException {
            os.writeBoolean(this.signedContent != null);
            if (this.signedContent == null) {
                return;
            }
            SignerInfo[] signerInfos = this.signedContent.getSignerInfos();
            os.writeInt(signerInfos.length);
            for (int i = 0; i < signerInfos.length; ++i) {
                this.saveSignerInfo(signerInfos[i], os, saveContext);
            }
            Map<String, Object> contentMDResults = this.signedContent.getContentMDResults();
            os.writeInt(contentMDResults == null ? -1 : contentMDResults.size());
            if (contentMDResults != null) {
                for (Map.Entry<String, Object> entry : contentMDResults.entrySet()) {
                    String path = entry.getKey();
                    os.writeUTF(path);
                    Object[] signerResults = (Object[])entry.getValue();
                    SignerInfo[] entrySigners = (SignerInfo[])signerResults[0];
                    byte[][] entryResults = (byte[][])signerResults[1];
                    os.writeInt(entrySigners.length);
                    for (int i = 0; i < entrySigners.length; ++i) {
                        this.saveSignerInfo(entrySigners[i], os, saveContext);
                        os.writeInt(entryResults[i].length);
                        os.write(entryResults[i]);
                    }
                }
            }
            for (int i = 0; i < signerInfos.length; ++i) {
                SignerInfo tsaInfo = this.signedContent.getTSASignerInfo(signerInfos[i]);
                os.writeBoolean(tsaInfo != null);
                if (tsaInfo == null) continue;
                this.saveSignerInfo(tsaInfo, os, saveContext);
                Date signingTime = this.signedContent.getSigningTime(signerInfos[i]);
                os.writeLong(signingTime != null ? signingTime.getTime() : Long.MIN_VALUE);
            }
        }

        private void saveSignerInfo(SignerInfo signerInfo, DataOutputStream os, List<SignerInfo> saveContext) throws IOException {
            int cacheIdx = saveContext.indexOf(signerInfo);
            os.writeInt(cacheIdx);
            if (cacheIdx >= 0) {
                return;
            }
            Certificate[] certs = signerInfo.getCertificateChain();
            int anchorIndex = -1;
            os.writeInt(certs == null ? 0 : certs.length);
            if (certs != null) {
                for (int i = 0; i < certs.length; ++i) {
                    byte[] certBytes;
                    if (certs[i].equals(signerInfo.getTrustAnchor())) {
                        anchorIndex = i;
                    }
                    try {
                        certBytes = certs[i].getEncoded();
                    }
                    catch (CertificateEncodingException e) {
                        throw (IOException)new IOException(e.getMessage()).initCause(e);
                    }
                    os.writeInt(certBytes.length);
                    os.write(certBytes);
                }
            }
            os.writeInt(anchorIndex);
            os.writeUTF(signerInfo.getMessageDigestAlgorithm());
            saveContext.add(signerInfo);
        }

        public SignedContent getSignedContent() {
            return this.signedContent;
        }
    }
}

