/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.signedcontent;

import java.security.cert.Certificate;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.osgi.internal.framework.EquinoxBundle;
import org.eclipse.osgi.internal.signedcontent.SignedBundleHook;
import org.eclipse.osgi.internal.signedcontent.SignedContentImpl;
import org.eclipse.osgi.internal.signedcontent.SignedStorageHook;
import org.eclipse.osgi.internal.signedcontent.SignerInfoImpl;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.storage.BundleInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class TrustEngineListener {
    private final BundleContext context;
    private final SignedBundleHook signedBundleHook;

    TrustEngineListener(BundleContext context, SignedBundleHook signedBundleHook) {
        this.context = context;
        this.signedBundleHook = signedBundleHook;
    }

    public void addedTrustAnchor(Certificate anchor) {
        Bundle[] bundles = this.context.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            SignedContentImpl signedContent = this.getSignedContent(bundles[i]);
            if (signedContent == null || !signedContent.isSigned()) continue;
            SignerInfo[] infos = signedContent.getSignerInfos();
            for (int j = 0; j < infos.length; ++j) {
                if (infos[j].getTrustAnchor() == null) {
                    this.signedBundleHook.determineTrust(signedContent, 2);
                    continue;
                }
                SignerInfo tsa = signedContent.getTSASignerInfo(infos[j]);
                if (tsa == null || tsa.getTrustAnchor() != null) continue;
                this.signedBundleHook.determineTrust(signedContent, 2);
            }
        }
    }

    public void removedTrustAnchor(Certificate anchor) {
        Bundle[] bundles = this.context.getBundles();
        HashSet<Bundle> usingAnchor = new HashSet<Bundle>();
        HashSet<SignerInfo> untrustedSigners = new HashSet<SignerInfo>();
        for (int i = 0; i < bundles.length; ++i) {
            SignedContentImpl signedContent = this.getSignedContent(bundles[i]);
            if (signedContent == null || !signedContent.isSigned()) continue;
            SignerInfo[] infos = signedContent.getSignerInfos();
            for (int j = 0; j < infos.length; ++j) {
                SignerInfo tsa;
                if (anchor.equals(infos[j].getTrustAnchor())) {
                    untrustedSigners.add(infos[j]);
                    usingAnchor.add(bundles[i]);
                }
                if ((tsa = signedContent.getTSASignerInfo(infos[j])) == null || !anchor.equals(tsa.getTrustAnchor())) continue;
                usingAnchor.add(bundles[i]);
                untrustedSigners.add(tsa);
            }
        }
        Iterator untrusted = untrustedSigners.iterator();
        while (untrusted.hasNext()) {
            ((SignerInfoImpl)untrusted.next()).setTrustAnchor(null);
        }
        for (Bundle bundle : usingAnchor) {
            SignedContentImpl signedContent = this.getSignedContent(bundle);
            this.signedBundleHook.determineTrust(signedContent, 2);
        }
    }

    private SignedContentImpl getSignedContent(Bundle bundle) {
        BundleInfo.Generation generation = (BundleInfo.Generation)((EquinoxBundle)bundle).getModule().getCurrentRevision().getRevisionInfo();
        SignedStorageHook.StorageHookImpl hook = (SignedStorageHook.StorageHookImpl)generation.getStorageHook(SignedStorageHook.class);
        return hook != null ? hook.signedContent : null;
    }
}

