/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.weaving;

import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.eclipse.osgi.internal.hookregistry.ClassLoaderHook;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.classpath.ClasspathEntry;
import org.eclipse.osgi.internal.permadmin.BundlePermissions;
import org.eclipse.osgi.internal.serviceregistry.HookContext;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import org.eclipse.osgi.internal.weaving.DynamicImportList;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.StorageUtil;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.BundleException;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.weaving.WeavingException;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.framework.hooks.weaving.WovenClassListener;
import org.osgi.framework.wiring.BundleWiring;

public final class WovenClassImpl
implements WovenClass,
HookContext {
    private static final byte FLAG_HOOKCALLED = 1;
    private static final byte FLAG_HOOKSCOMPLETE = 2;
    private static final byte FLAG_WEAVINGCOMPLETE = 4;
    private static final String weavingHookName = WeavingHook.class.getName();
    private final String className;
    private final BundleEntry entry;
    private final List<String> dynamicImports;
    private final ClasspathEntry classpathEntry;
    private final BundleLoader loader;
    final ServiceRegistry registry;
    private final Map<ServiceRegistration<?>, Boolean> blackList;
    private byte[] validBytes;
    private byte[] resultBytes;
    private byte hookFlags = 0;
    private Throwable error;
    private ServiceRegistration<?> errorHook;
    private Class<?> clazz;
    private int state;
    final EquinoxContainer container;

    public WovenClassImpl(String className, byte[] bytes, BundleEntry entry, ClasspathEntry classpathEntry, BundleLoader loader, EquinoxContainer container, Map<ServiceRegistration<?>, Boolean> blacklist) {
        this.className = className;
        this.resultBytes = bytes;
        this.validBytes = bytes;
        this.entry = entry;
        this.dynamicImports = new DynamicImportList(this);
        this.classpathEntry = classpathEntry;
        this.loader = loader;
        this.registry = container.getServiceRegistry();
        this.container = container;
        this.blackList = blacklist;
        this.setState(1);
    }

    public byte[] getBytes() {
        if ((this.hookFlags & 2) == 0) {
            this.checkPermission();
            return this.validBytes;
        }
        byte[] current = this.validBytes;
        byte[] results = new byte[current.length];
        System.arraycopy(current, 0, results, 0, current.length);
        return results;
    }

    public void setBytes(byte[] newBytes) {
        this.checkPermission();
        if (newBytes == null) {
            throw new NullPointerException("newBytes cannot be null.");
        }
        if ((this.hookFlags & 2) != 0) {
            throw new IllegalStateException("Weaving has completed already.");
        }
        this.validBytes = newBytes;
        this.resultBytes = newBytes;
    }

    void checkPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new AdminPermission(this.loader.getWiring().getBundle(), "weave"));
        }
    }

    public List<String> getDynamicImports() {
        if ((this.hookFlags & 2) == 0) {
            return this.dynamicImports;
        }
        return Collections.unmodifiableList(this.dynamicImports);
    }

    public boolean isWeavingComplete() {
        return (this.hookFlags & 4) != 0;
    }

    private void setHooksComplete() {
        byte[] original = this.validBytes;
        this.validBytes = new byte[original.length];
        System.arraycopy(original, 0, this.validBytes, 0, original.length);
        this.hookFlags = (byte)(this.hookFlags | 2);
    }

    void setWeavingCompleted(Class<?> clazz) {
        this.clazz = clazz;
        this.hookFlags = (byte)(this.hookFlags | 4);
        if ((this.hookFlags & 1) == 0) {
            return;
        }
        if (this.error != null) {
            return;
        }
        this.setState(clazz == null ? 16 : 4);
        this.notifyWovenClassListeners();
    }

    public String getClassName() {
        return this.className;
    }

    public ProtectionDomain getProtectionDomain() {
        return this.classpathEntry.getDomain();
    }

    public Class<?> getDefinedClass() {
        return this.clazz;
    }

    public BundleWiring getBundleWiring() {
        return this.loader.getWiring();
    }

    @Override
    public void call(Object hook, ServiceRegistration<?> hookRegistration) throws Exception {
        if (this.error != null) {
            return;
        }
        if (hook instanceof WeavingHook) {
            if (this.blackList.containsKey(hookRegistration)) {
                return;
            }
            if ((this.hookFlags & 1) == 0) {
                this.hookFlags = (byte)(this.hookFlags | 1);
                if (!this.validBytes(this.validBytes)) {
                    this.validBytes = StorageUtil.getBytes(this.entry.getInputStream(), (int)this.entry.getSize(), 8192);
                }
            }
            try {
                ((WeavingHook)hook).weave((WovenClass)this);
            }
            catch (WeavingException e) {
                this.error = e;
                this.errorHook = hookRegistration;
            }
            catch (Throwable t) {
                this.error = t;
                this.errorHook = hookRegistration;
                this.blackList.put(hookRegistration, Boolean.TRUE);
            }
        }
    }

    private boolean validBytes(byte[] checkBytes) {
        if (checkBytes == null || checkBytes.length < 4) {
            return false;
        }
        if ((checkBytes[0] & 0xCA) != 202) {
            return false;
        }
        if ((checkBytes[1] & 0xFE) != 254) {
            return false;
        }
        if ((checkBytes[2] & 0xBA) != 186) {
            return false;
        }
        return (checkBytes[3] & 0xBE) == 190;
    }

    @Override
    public String getHookMethodName() {
        return "weave";
    }

    @Override
    public String getHookClassName() {
        return weavingHookName;
    }

    private void notifyWovenClassListeners() {
        final HookContext context = new HookContext(){

            @Override
            public void call(Object hook, ServiceRegistration<?> hookRegistration) throws Exception {
                if (!(hook instanceof WovenClassListener)) {
                    return;
                }
                try {
                    ((WovenClassListener)hook).modified((WovenClass)WovenClassImpl.this);
                }
                catch (Exception e) {
                    WovenClassImpl.this.container.getEventPublisher().publishFrameworkEvent(2, hookRegistration.getReference().getBundle(), e);
                }
            }

            @Override
            public String getHookClassName() {
                return WovenClassListener.class.getName();
            }

            @Override
            public String getHookMethodName() {
                return "modified";
            }
        };
        if (System.getSecurityManager() == null) {
            this.registry.notifyHooksPrivileged(context);
        } else {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() {
                        WovenClassImpl.this.registry.notifyHooksPrivileged(context);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (RuntimeException)e.getException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] callHooks() throws Throwable {
        List<String> newImports;
        byte[] wovenBytes;
        block18: {
            SecurityManager sm = System.getSecurityManager();
            wovenBytes = null;
            newImports = null;
            boolean rejected = false;
            try {
                if (sm == null) {
                    this.registry.notifyHooksPrivileged(this);
                } else {
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                            @Override
                            public Void run() {
                                WovenClassImpl.this.registry.notifyHooksPrivileged(WovenClassImpl.this);
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        throw (RuntimeException)e.getException();
                    }
                }
                if ((this.hookFlags & 1) == 0) break block18;
            }
            catch (Throwable throwable) {
                if ((this.hookFlags & 1) != 0) {
                    for (ClassLoaderHook classLoaderHook : this.container.getConfiguration().getHookRegistry().getClassLoaderHooks()) {
                        rejected |= classLoaderHook.rejectTransformation(this.className, this.resultBytes, this.classpathEntry, this.entry, this.loader.getModuleClassLoader().getClasspathManager());
                    }
                    if (!rejected) {
                        wovenBytes = this.resultBytes;
                        newImports = this.dynamicImports;
                    }
                    this.setHooksComplete();
                    this.setState(this.error == null ? 2 : 8);
                    if (!rejected) {
                        this.notifyWovenClassListeners();
                    }
                }
                throw throwable;
            }
            for (ClassLoaderHook classLoaderHook : this.container.getConfiguration().getHookRegistry().getClassLoaderHooks()) {
                rejected |= classLoaderHook.rejectTransformation(this.className, this.resultBytes, this.classpathEntry, this.entry, this.loader.getModuleClassLoader().getClasspathManager());
            }
            if (!rejected) {
                wovenBytes = this.resultBytes;
                newImports = this.dynamicImports;
            }
            this.setHooksComplete();
            this.setState(this.error == null ? 2 : 8);
            if (!rejected) {
                this.notifyWovenClassListeners();
            }
        }
        if (this.error != null) {
            throw this.error;
        }
        if (newImports != null) {
            for (String newImport : newImports) {
                try {
                    ManifestElement[] importElements = ManifestElement.parseHeader("Import-Package", newImport);
                    this.addImpliedImportPackagePermissions(importElements);
                    this.loader.addDynamicImportPackage(importElements);
                }
                catch (BundleException e) {}
            }
        }
        return wovenBytes;
    }

    private void addImpliedImportPackagePermissions(ManifestElement[] importElements) {
        ProtectionDomain wovenDomain = ((BundleInfo.Generation)((ModuleRevision)this.getBundleWiring().getRevision()).getRevisionInfo()).getDomain();
        if (wovenDomain != null) {
            for (ManifestElement clause : importElements) {
                for (String pkg : clause.getValueComponents()) {
                    ((BundlePermissions)wovenDomain.getPermissions()).addWovenPermission(new PackagePermission(pkg, "import"));
                }
            }
        }
    }

    public String toString() {
        return this.className;
    }

    public ServiceRegistration<?> getErrorHook() {
        return this.errorHook;
    }

    public int getState() {
        return this.state;
    }

    private void setState(int value) {
        this.state = value;
    }
}

