/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.storage;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.osgi.internal.debug.Debug;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class StorageUtil {
    public static final byte NULL = 0;
    public static final byte OBJECT = 1;

    public static void copyDir(File inDir, File outDir) throws IOException {
        String[] files = inDir.list();
        if (files != null && files.length > 0) {
            outDir.mkdir();
            for (int i = 0; i < files.length; ++i) {
                File inFile = new File(inDir, files[i]);
                File outFile = new File(outDir, files[i]);
                if (inFile.isDirectory()) {
                    StorageUtil.copyDir(inFile, outFile);
                    continue;
                }
                FileInputStream in = new FileInputStream(inFile);
                StorageUtil.readFile(in, outFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readFile(InputStream in, File file) throws IOException {
        FileOutputStream fos = null;
        try {
            int count;
            fos = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((count = in.read(buffer, 0, buffer.length)) > 0) {
                fos.write(buffer, 0, count);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ee) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean rm(File file, boolean DEBUG) {
        if (file.exists()) {
            String[] list;
            if (file.isDirectory() && (list = file.list()) != null) {
                int len = list.length;
                for (int i = 0; i < len; ++i) {
                    StorageUtil.rm(new File(file, list[i]), DEBUG);
                }
            }
            if (DEBUG) {
                if (file.isDirectory()) {
                    Debug.println("rmdir " + file.getPath());
                } else {
                    Debug.println("rm " + file.getPath());
                }
            }
            boolean success = file.delete();
            if (DEBUG && !success) {
                Debug.println("  rm failed!!");
            }
            return success;
        }
        return true;
    }

    public static String readString(DataInputStream in, boolean intern) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        return intern ? in.readUTF().intern() : in.readUTF();
    }

    public static void writeStringOrNull(DataOutputStream out, String string) throws IOException {
        if (string == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(string);
        }
    }

    public static ServiceRegistration<?> register(String name, Object service, BundleContext context) {
        Hashtable properties = new Hashtable(7);
        Dictionary headers = context.getBundle().getHeaders();
        ((Dictionary)properties).put("service.vendor", headers.get("Bundle-Vendor"));
        ((Dictionary)properties).put("service.ranking", new Integer(Integer.MAX_VALUE));
        ((Dictionary)properties).put("service.pid", context.getBundle().getBundleId() + "." + service.getClass().getName());
        return context.registerService(name, service, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWrite(File installDir) {
        if (!installDir.canWrite()) {
            return false;
        }
        if (!installDir.isDirectory()) {
            return false;
        }
        File fileTest = null;
        try {
            fileTest = File.createTempFile("writtableArea", ".dll", installDir);
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileTest != null) {
                fileTest.delete();
            }
        }
        return true;
    }

    public static URL encodeFileURL(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(InputStream in, int length, int BUF_SIZE) throws IOException {
        byte[] classbytes;
        try {
            byte[] oldbytes;
            int bytesread;
            if (length > 0) {
                int readcount;
                classbytes = new byte[length];
                for (bytesread = 0; bytesread < length && (readcount = in.read(classbytes, bytesread, length - bytesread)) > 0; bytesread += readcount) {
                }
            } else {
                length = BUF_SIZE;
                classbytes = new byte[length];
                while (true) {
                    if (bytesread < length) {
                        int readcount = in.read(classbytes, bytesread, length - bytesread);
                        if (readcount > 0) {
                            bytesread += readcount;
                            continue;
                        }
                        break;
                    }
                    oldbytes = classbytes;
                    classbytes = new byte[length += BUF_SIZE];
                    System.arraycopy(oldbytes, 0, classbytes, 0, bytesread);
                }
            }
            if (classbytes.length > bytesread) {
                oldbytes = classbytes;
                classbytes = new byte[bytesread];
                System.arraycopy(oldbytes, 0, classbytes, 0, bytesread);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ee) {}
        }
        return classbytes;
    }
}

