/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.cosmos.equinox;

import com.github.veithen.cosmos.equinox.datalocation.LocationImpl;
import com.github.veithen.cosmos.equinox.signedcontent.DummySignedContentFactory;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private static final FileVisitor<Path> deletingFileVisitor = new SimpleFileVisitor<Path>(){

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            Files.delete(dir);
            return FileVisitResult.CONTINUE;
        }
    };
    private Path instanceArea;
    private Thread shutdownHook;

    public void start(BundleContext context) throws Exception {
        if ("true".equals(context.getProperty("cosmos.equinox.disableSignatureValidation"))) {
            context.registerService(SignedContentFactory.class, (Object)new DummySignedContentFactory(), null);
        }
        if ("true".equals(context.getProperty("cosmos.equinox.createTempInstanceArea"))) {
            try {
                this.instanceArea = Files.createTempDirectory("osgi.instance", new FileAttribute[0]);
                this.shutdownHook = new Thread(){

                    @Override
                    public void run() {
                        Activator.this.deleteInstanceArea();
                    }
                };
                Runtime.getRuntime().addShutdownHook(this.shutdownHook);
                LocationImpl location = new LocationImpl(null, null, false);
                URL url = this.instanceArea.toUri().toURL();
                location.set(url, false);
                Hashtable<String, String> properties = new Hashtable<String, String>();
                ((Dictionary)properties).put("type", "osgi.instance.area");
                ((Dictionary)properties).put("url", url.toExternalForm());
                context.registerService(Location.class, (Object)location, properties);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to create temporary directory for instance data", ex);
            }
        }
    }

    private void deleteInstanceArea() {
        try {
            Files.walkFileTree(this.instanceArea, deletingFileVisitor);
        }
        catch (IOException ex) {
            logger.error(String.format("Failed to delete directory %s", this.instanceArea), (Throwable)ex);
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.instanceArea != null) {
            this.deleteInstanceArea();
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
    }
}

