/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.cosmos.equinox.debug;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, xmlns="http://www.osgi.org/xmlns/scr/v1.1.0")
public final class DebugOptionsConfigurator {
    private static final Logger logger = LoggerFactory.getLogger(DebugOptionsConfigurator.class);
    private DebugOptions debugOptions;

    @Reference
    void setDebugOptions(DebugOptions debugOptions) {
        this.debugOptions = debugOptions;
    }

    @Activate
    void activate() {
        if (logger.isDebugEnabled()) {
            Enumeration<URL> e;
            this.debugOptions.setDebugEnabled(true);
            Properties props = new Properties();
            try {
                e = DebugOptionsConfigurator.class.getClassLoader().getResources("META-INF/cosmos/equinox-debug-options.properties");
            }
            catch (IOException ex) {
                logger.error("Failed to load META-INF/cosmos/equinox-debug-options.properties", (Throwable)ex);
                return;
            }
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                try {
                    InputStream in = url.openStream();
                    try {
                        props.load(in);
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (IOException ex) {
                    logger.error("Failed to load {}", (Object)url, (Object)ex);
                }
            }
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.debugOptions.setOption((String)key, (String)value)));
        }
    }
}

