/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.cosmos.osgi.runtime;

import com.github.veithen.cosmos.osgi.runtime.AbstractBundle;
import com.github.veithen.cosmos.osgi.runtime.BundleManager;
import com.github.veithen.cosmos.osgi.runtime.CosmosRuntime;
import com.github.veithen.cosmos.osgi.runtime.ServiceReferenceImpl;
import com.github.veithen.cosmos.osgi.runtime.ServiceRegistry;
import com.github.veithen.cosmos.osgi.runtime.SingletonServiceFactory;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Dictionary;
import java.util.LinkedList;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

final class BundleContextImpl
implements BundleContext {
    private final AbstractBundle bundle;
    private final CosmosRuntime runtime;
    private final BundleManager bundleManager;
    private final ServiceRegistry serviceRegistry;
    private final List<BundleListener> bundleListeners = new LinkedList<BundleListener>();

    BundleContextImpl(AbstractBundle bundle, CosmosRuntime runtime, BundleManager bundleManager, ServiceRegistry serviceRegistry) {
        this.bundle = bundle;
        this.runtime = runtime;
        this.bundleManager = bundleManager;
        this.serviceRegistry = serviceRegistry;
    }

    public String getProperty(String key) {
        return this.runtime.getProperty(key);
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public Bundle installBundle(String location, InputStream input) throws BundleException {
        throw new UnsupportedOperationException();
    }

    public Bundle installBundle(String location) throws BundleException {
        throw new UnsupportedOperationException();
    }

    public Bundle getBundle(long id) {
        return this.bundleManager.getBundle(id);
    }

    public Bundle[] getBundles() {
        return this.bundleManager.getBundles();
    }

    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.serviceRegistry.addServiceListener(this.bundle, listener, FrameworkUtil.createFilter((String)filter));
    }

    public void addServiceListener(ServiceListener listener) {
        this.serviceRegistry.addServiceListener(this.bundle, listener, null);
    }

    public void removeServiceListener(ServiceListener listener) {
        this.serviceRegistry.removeServiceListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBundleListener(BundleListener listener) {
        List<BundleListener> list = this.bundleListeners;
        synchronized (list) {
            this.bundleListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBundleListener(BundleListener listener) {
        List<BundleListener> list = this.bundleListeners;
        synchronized (list) {
            this.bundleListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void distributeBundleEvent(BundleEvent event) {
        BundleListener[] bundleListeners;
        List<BundleListener> list = this.bundleListeners;
        synchronized (list) {
            bundleListeners = this.bundleListeners.toArray(new BundleListener[this.bundleListeners.size()]);
        }
        for (BundleListener listener : bundleListeners) {
            listener.bundleChanged(event);
        }
    }

    public void addFrameworkListener(FrameworkListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeFrameworkListener(FrameworkListener listener) {
        throw new UnsupportedOperationException();
    }

    public ServiceRegistration<?> registerService(String[] clazzes, Object service, Dictionary<String, ?> properties) {
        if (service instanceof ServiceFactory) {
            return this.serviceRegistry.registerService(this.bundle, clazzes, (ServiceFactory)service, properties);
        }
        return this.serviceRegistry.registerService(this.bundle, clazzes, new SingletonServiceFactory<Object>(service), properties);
    }

    public ServiceRegistration<?> registerService(String clazz, Object service, Dictionary<String, ?> properties) {
        return this.registerService(new String[]{clazz}, service, properties);
    }

    public <S> ServiceRegistration<S> registerService(Class<S> clazz, S service, Dictionary<String, ?> properties) {
        return this.serviceRegistry.registerService(this.bundle, new String[]{clazz.getName()}, new SingletonServiceFactory<S>(service), properties);
    }

    public <S> ServiceRegistration<S> registerService(Class<S> clazz, ServiceFactory<S> factory, Dictionary<String, ?> properties) {
        return this.serviceRegistry.registerService(this.bundle, new String[]{clazz.getName()}, factory, properties);
    }

    public ServiceReference<?> getServiceReference(String clazz) {
        return this.serviceRegistry.getServiceReference(clazz, null, Object.class);
    }

    public <S> ServiceReference<S> getServiceReference(Class<S> clazz) {
        return this.serviceRegistry.getServiceReference(clazz.getName(), null, clazz);
    }

    public ServiceReference<?>[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        List<ServiceReference<Object>> references = this.serviceRegistry.getServiceReferences(clazz, filter == null ? null : FrameworkUtil.createFilter((String)filter), Object.class);
        return references.toArray(new ServiceReference[references.size()]);
    }

    public <S> Collection<ServiceReference<S>> getServiceReferences(Class<S> clazz, String filter) throws InvalidSyntaxException {
        return this.serviceRegistry.getServiceReferences(clazz.getName(), filter == null ? null : FrameworkUtil.createFilter((String)filter), clazz);
    }

    public ServiceReference<?>[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        return this.getServiceReferences(clazz, filter);
    }

    public <S> S getService(ServiceReference<S> reference) {
        return ((ServiceReferenceImpl)reference).getService(this.bundle);
    }

    public <S> ServiceObjects<S> getServiceObjects(ServiceReference<S> reference) {
        throw new UnsupportedOperationException();
    }

    public boolean ungetService(ServiceReference<?> reference) {
        return true;
    }

    public File getDataFile(String filename) {
        return this.bundle.getDataFile(filename);
    }

    public Filter createFilter(String filter) throws InvalidSyntaxException {
        return FrameworkUtil.createFilter((String)filter);
    }

    public Bundle getBundle(String location) {
        throw new UnsupportedOperationException();
    }

    void destroy() {
        this.serviceRegistry.unregisterServices(this.bundle);
    }
}

