/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.cosmos.osgi.runtime;

import com.github.veithen.cosmos.osgi.runtime.AbstractBundle;
import com.github.veithen.cosmos.osgi.runtime.BundleContextFactory;
import com.github.veithen.cosmos.osgi.runtime.BundleManager;
import com.github.veithen.cosmos.osgi.runtime.BundleState;
import com.github.veithen.cosmos.osgi.runtime.Element;
import com.github.veithen.cosmos.osgi.runtime.Lazy;
import com.github.veithen.cosmos.osgi.runtime.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BundleImpl
extends AbstractBundle {
    private static final Logger logger = LoggerFactory.getLogger(BundleImpl.class);
    private static final Reason<BundleImpl> USED_BY_BUNDLE = new Reason<BundleImpl>(){

        @Override
        String format(BundleImpl context) {
            return "it is used by bundle " + context.symbolicName;
        }
    };
    private static final Reason<String> CLASS_LOADING_REQUEST = new Reason<String>(){

        @Override
        String format(String context) {
            return "request to load class " + context;
        }
    };
    private final BundleManager bundleManager;
    private final long id;
    private final String symbolicName;
    private final Attributes attrs;
    private final URL rootUrl;
    private final URL locationUrl;
    private BundleContextFactory bundleContextFactory;
    private BundleState state;
    private BundleActivator activator;
    private final Lazy<Set<String>> entries = new Lazy<Set<String>>(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        Set<String> initialize() {
            HashSet<String> entries = new HashSet<String>();
            try (JarInputStream in = new JarInputStream(BundleImpl.this.locationUrl.openStream());){
                JarEntry entry;
                while ((entry = in.getNextJarEntry()) != null) {
                    entries.add(entry.getName());
                }
                HashSet<String> hashSet = entries;
                return hashSet;
            }
            catch (IOException ex) {
                logger.warn(String.format("Failed to read entries for bundle %s", BundleImpl.this.symbolicName), (Throwable)ex);
                return Collections.emptySet();
            }
        }
    };
    private final Lazy<ResourceBundle> resourceBundle = new Lazy<ResourceBundle>(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        ResourceBundle initialize() {
            try {
                URL entry;
                String localization = BundleImpl.this.getHeaderValue("Bundle-Localization");
                if (localization == null) {
                    localization = "OSGI-INF/l10n/bundle";
                }
                if ((entry = BundleImpl.this.getEntry(localization + ".properties")) == null) {
                    return null;
                }
                try (InputStream in = entry.openStream();){
                    PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(in);
                    return propertyResourceBundle;
                }
            }
            catch (IOException | BundleException ex) {
                logger.warn(String.format("Failed to load bundle localization for bundle %s", BundleImpl.this.symbolicName), ex);
                return null;
            }
        }
    };

    public BundleImpl(BundleManager bundleManager, long id, String symbolicName, Attributes attrs, URL rootUrl) throws BundleException {
        this.bundleManager = bundleManager;
        this.id = id;
        this.symbolicName = symbolicName;
        this.attrs = attrs;
        this.rootUrl = rootUrl;
        if (rootUrl.getProtocol().equals("jar")) {
            String path = rootUrl.getPath();
            try {
                this.locationUrl = new URL(path.substring(0, path.lastIndexOf(33)));
            }
            catch (MalformedURLException ex) {
                throw new BundleException("Failed to extract bundle URL", (Throwable)ex);
            }
        } else {
            this.locationUrl = rootUrl;
        }
    }

    @Override
    void initialize(BundleContextFactory bundleContextFactory) throws BundleException {
        this.bundleContextFactory = bundleContextFactory;
        if ("lazy".equals(this.getHeaderValue("Bundle-ActivationPolicy")) || "true".equals(this.getHeaderValue("Eclipse-LazyStart")) || "true".equals(this.getHeaderValue("Eclipse-AutoStart"))) {
            this.state = BundleState.LAZY_ACTIVATE;
            this.context = bundleContextFactory.createBundleContext(this);
        } else {
            this.state = BundleState.LOADED;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Loaded bundle " + this.symbolicName + " with initial state " + (Object)((Object)this.state));
        }
    }

    @Override
    String getHeaderValue(String name) throws BundleException {
        Element[] elements;
        String value = this.attrs.getValue(name);
        if (value == null) {
            return null;
        }
        try {
            elements = Element.parseHeaderValue(value);
        }
        catch (ParseException ex) {
            throw new BundleException("Unable to parse " + name + " header", 3, (Throwable)ex);
        }
        if (elements.length != 1) {
            throw new BundleException("Expected only a single value for header " + name, 3);
        }
        return elements[0].getValue();
    }

    public long getBundleId() {
        return this.id;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public Version getVersion() {
        return Version.parseVersion((String)this.attrs.getValue("Bundle-Version"));
    }

    public int getState() {
        return this.state.getOsgiState();
    }

    public Dictionary<String, String> getHeaders() {
        Hashtable<String, String> headers = new Hashtable<String, String>();
        for (Map.Entry<Object, Object> entry : this.attrs.entrySet()) {
            headers.put(((Attributes.Name)entry.getKey()).toString(), (String)entry.getValue());
        }
        return headers;
    }

    public Dictionary<String, String> getHeaders(String locale) {
        return this.getHeaders();
    }

    public void start(int options) throws BundleException {
        this.start();
    }

    private void makeDependenciesReady() throws BundleException {
        String importPackage;
        String requireBundle = this.attrs.getValue("Require-Bundle");
        if (requireBundle != null) {
            Element[] elements;
            try {
                elements = Element.parseHeaderValue(requireBundle);
            }
            catch (ParseException ex) {
                throw new BundleException("Unable to parse Require-Bundle header", 3, (Throwable)ex);
            }
            for (Element element : elements) {
                BundleImpl bundle = (BundleImpl)this.bundleManager.getBundle(element.getValue());
                if (bundle == null) continue;
                bundle.makeReady(USED_BY_BUNDLE, this);
            }
        }
        if ((importPackage = this.attrs.getValue("Import-Package")) != null) {
            Element[] elements;
            try {
                elements = Element.parseHeaderValue(importPackage);
            }
            catch (ParseException ex) {
                throw new BundleException("Unable to parse Import-Package header", 3, (Throwable)ex);
            }
            for (Element element : elements) {
                BundleImpl bundle = this.bundleManager.getBundleByPackage(element.getValue());
                if (bundle == null || bundle == this) continue;
                bundle.makeReady(USED_BY_BUNDLE, this);
            }
        }
        this.state = BundleState.READY;
    }

    private <T> void makeReady(Reason<T> reason, T context) throws BundleException {
        switch (this.state) {
            case LOADED: {
                if (logger.isDebugEnabled()) {
                    logger.debug("Need to make bundle " + this.symbolicName + " ready; reason: " + reason.format(context));
                }
                this.makeDependenciesReady();
                break;
            }
            case LAZY_ACTIVATE: {
                if (logger.isDebugEnabled()) {
                    logger.debug("Need to start bundle " + this.symbolicName + "; reason: " + reason.format(context));
                }
                this.start();
                break;
            }
        }
    }

    public void start() throws BundleException {
        String activatorClassName;
        if (this.state == BundleState.ACTIVE) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Starting bundle " + this.symbolicName + " ...");
        }
        if (this.state == BundleState.LOADED || this.state == BundleState.LAZY_ACTIVATE) {
            this.makeDependenciesReady();
        }
        this.bundleManager.fireBundleEvent(this, 128);
        if (this.context == null) {
            this.context = this.bundleContextFactory.createBundleContext(this);
        }
        if ((activatorClassName = this.attrs.getValue("Bundle-Activator")) != null) {
            try {
                this.activator = (BundleActivator)Class.forName(activatorClassName).newInstance();
            }
            catch (Exception ex) {
                throw new BundleException("Failed to instantiate bundle activator " + activatorClassName, (Throwable)ex);
            }
            try {
                this.activator.start((BundleContext)this.context);
            }
            catch (Exception ex) {
                throw new BundleException("Failed to start bundle " + this.symbolicName, (Throwable)ex);
            }
        }
        this.state = BundleState.ACTIVE;
        if (logger.isDebugEnabled()) {
            logger.debug("Bundle " + this.symbolicName + " started");
        }
        this.bundleManager.fireBundleEvent(this, 2);
    }

    public void stop(int options) throws BundleException {
        throw new UnsupportedOperationException();
    }

    public void stop() throws BundleException {
        if (this.state == BundleState.LOADED || this.state == BundleState.READY) {
            return;
        }
        logger.debug("Stopping bundle {} ...", (Object)this.symbolicName);
        this.bundleManager.fireBundleEvent(this, 256);
        if (this.state == BundleState.ACTIVE && this.activator != null) {
            try {
                this.activator.stop((BundleContext)this.context);
            }
            catch (Exception ex) {
                throw new BundleException("Failed to stop bundle " + this.symbolicName, (Throwable)ex);
            }
        }
        this.context.destroy();
        this.context = null;
        this.state = BundleState.READY;
        this.bundleManager.fireBundleEvent(this, 4);
        logger.debug("Bundle {} stopped", (Object)this.symbolicName);
    }

    public URL getEntry(String path) {
        if (path.equals("/")) {
            return this.rootUrl;
        }
        if (this.entries.get().contains(path)) {
            try {
                return new URL(this.rootUrl, path);
            }
            catch (MalformedURLException ex) {
                return null;
            }
        }
        return null;
    }

    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        if (!recurse && filePattern.indexOf(42) == -1 && filePattern.indexOf(63) == -1) {
            Vector<URL> entries = new Vector<URL>();
            URL entry = this.getEntry(path + "/" + filePattern);
            if (entry != null) {
                entries.add(entry);
            }
            return entries.elements();
        }
        return new Vector().elements();
    }

    public URL getLocationUrl() {
        return this.locationUrl;
    }

    public String getLocation() {
        return this.locationUrl.toString();
    }

    @Override
    void beforeLoadClass(String name) throws BundleException {
        this.makeReady(CLASS_LOADING_REQUEST, name);
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle.get();
    }

    static abstract class Reason<T> {
        Reason() {
        }

        abstract String format(T var1);
    }
}

