/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.cosmos.osgi.runtime;

import com.github.veithen.cosmos.osgi.runtime.AbstractBundle;
import com.github.veithen.cosmos.osgi.runtime.BundleContextFactory;
import com.github.veithen.cosmos.osgi.runtime.BundleManager;
import com.github.veithen.cosmos.osgi.runtime.InternalLoggerFactoryImpl;
import com.github.veithen.cosmos.osgi.runtime.LogServiceFactory;
import com.github.veithen.cosmos.osgi.runtime.PackageAdminImpl;
import com.github.veithen.cosmos.osgi.runtime.Patcher;
import com.github.veithen.cosmos.osgi.runtime.ResourceProcessor;
import com.github.veithen.cosmos.osgi.runtime.ResourceUtil;
import com.github.veithen.cosmos.osgi.runtime.ServiceReferenceImpl;
import com.github.veithen.cosmos.osgi.runtime.ServiceRegistry;
import com.github.veithen.cosmos.osgi.runtime.internal.InternalLoggerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.xml.XMLParserActivator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CosmosRuntime {
    private static final Logger logger = LoggerFactory.getLogger(CosmosRuntime.class);
    private static CosmosRuntime instance;
    private final Properties properties = new Properties();
    private final BundleManager bundleManager = new BundleManager();
    private final ServiceRegistry serviceRegistry = new ServiceRegistry();

    /*
     * WARNING - void declaration
     */
    private CosmosRuntime() throws BundleException {
        void var7_9;
        BundleContextFactory bundleContextFactory = new BundleContextFactory(this, this.bundleManager, this.serviceRegistry);
        this.bundleManager.initialize(bundleContextFactory);
        this.loadProperties("META-INF/cosmos.properties");
        if (logger.isDebugEnabled()) {
            this.loadProperties("META-INF/cosmos-debug.properties");
            logger.debug(String.format("Properties: %s", this.properties));
        }
        AbstractBundle systemBundle = this.bundleManager.getBundle(0L);
        this.registerSAXParserFactory(systemBundle);
        this.registerDocumentBuilderFactory(systemBundle);
        systemBundle.getBundleContext().registerService(PackageAdmin.class, (Object)new PackageAdminImpl(this.bundleManager), null);
        systemBundle.getBundleContext().registerService(Logger.class, (Object)logger, null);
        InternalLoggerFactoryImpl internalLoggerFactory = new InternalLoggerFactoryImpl();
        systemBundle.getBundleContext().registerService(InternalLoggerFactory.class, (Object)internalLoggerFactory, null);
        systemBundle.getBundleContext().registerService(LogService.class, (ServiceFactory)new LogServiceFactory(internalLoggerFactory), null);
        final HashSet<AbstractBundle> autostartBundles = new HashSet<AbstractBundle>();
        AbstractBundle[] arr$ = this.bundleManager.getBundles();
        int len$ = arr$.length;
        boolean bl = false;
        while (var7_9 < len$) {
            AbstractBundle bundle = arr$[var7_9];
            if ("true".equals(bundle.getHeaderValue("Cosmos-AutoStart"))) {
                autostartBundles.add(bundle);
            }
            ++var7_9;
        }
        ResourceUtil.processResources("META-INF/cosmos-autostart-bundles.list", new ResourceProcessor(){

            @Override
            public void process(URL url, InputStream in) throws IOException, BundleException {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, "utf-8"));
                while ((line = reader.readLine()) != null) {
                    if (line.isEmpty() || line.startsWith("#")) continue;
                    Bundle bundle = CosmosRuntime.this.bundleManager.getBundle(line);
                    if (bundle == null) {
                        throw new BundleException(String.format("Bundle %s listed in %s not found", line, url));
                    }
                    autostartBundles.add(bundle);
                }
            }
        });
        Bundle scrBundle = this.bundleManager.getBundle("org.apache.felix.scr");
        if (scrBundle != null) {
            scrBundle.start();
        }
        for (Bundle bundle : autostartBundles) {
            bundle.start();
        }
    }

    private void registerSAXParserFactory(Bundle bundle) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        Hashtable props = new Hashtable();
        new XMLParserActivator().setSAXProperties(factory, props);
        bundle.getBundleContext().registerService(SAXParserFactory.class, (Object)factory, props);
    }

    private void registerDocumentBuilderFactory(Bundle bundle) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Hashtable props = new Hashtable();
        new XMLParserActivator().setDOMProperties(factory, props);
        bundle.getBundleContext().registerService(DocumentBuilderFactory.class, (Object)factory, props);
    }

    private void loadProperties(String resourceName) throws BundleException {
        ResourceUtil.processResources(resourceName, new ResourceProcessor(){

            @Override
            public void process(URL url, InputStream in) throws IOException {
                CosmosRuntime.this.properties.load(in);
            }
        });
    }

    public static synchronized CosmosRuntime getInstance() throws BundleException {
        if (instance == null) {
            Patcher.patch();
            instance = new CosmosRuntime();
        }
        return instance;
    }

    String getProperty(String key) {
        String value = this.properties.getProperty(key);
        if (value == null) {
            System.getProperty(key);
        }
        if (value == null && logger.isDebugEnabled()) {
            logger.debug("No value for property " + key);
        }
        return value;
    }

    public <T> T getService(Class<T> clazz) {
        ServiceReference<T> ref = this.serviceRegistry.getServiceReference(clazz.getName(), null, clazz);
        return ref == null ? null : (T)((ServiceReferenceImpl)ref).getService(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        AbstractBundle[] bundles = this.bundleManager.getBundles();
        for (int i = 1; i < bundles.length; ++i) {
            AbstractBundle bundle = bundles[i];
            try {
                bundle.stop();
                continue;
            }
            catch (BundleException ex) {
                logger.warn(String.format("Failed to stop bundle %s", bundle.getSymbolicName()), (Throwable)ex);
            }
        }
        Class<CosmosRuntime> clazz = CosmosRuntime.class;
        synchronized (CosmosRuntime.class) {
            instance = null;
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }
}

