/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.cosmos.osgi.runtime;

import com.github.veithen.cosmos.osgi.runtime.internal.InternalLogger;
import org.slf4j.Logger;

final class InternalLoggerImpl
implements InternalLogger {
    private final Logger logger;
    private final String prefix;

    InternalLoggerImpl(Logger logger, String prefix) {
        this.logger = logger;
        this.prefix = prefix;
    }

    @Override
    public void log(int level, String message, Throwable exception) {
        switch (level) {
            case 4: {
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug(this.prefix + message, exception);
                break;
            }
            case 3: {
                if (!this.logger.isInfoEnabled()) break;
                this.logger.info(this.prefix + message, exception);
                break;
            }
            case 2: {
                if (!this.logger.isWarnEnabled()) break;
                this.logger.warn(this.prefix + message, exception);
                break;
            }
            case 1: {
                if (!this.logger.isErrorEnabled()) break;
                this.logger.error(this.prefix + message, exception);
            }
        }
    }
}

