/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.cosmos.osgi.runtime;

import com.github.veithen.cosmos.osgi.runtime.RelocatingClassVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

final class MemberInjector
extends ClassVisitor {
    private final ClassNode classNode;
    private String name;
    private boolean fieldsInjected;

    MemberInjector(ClassVisitor cv, ClassNode classNode) {
        super(393216, cv);
        this.classNode = classNode;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.name = name;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (!this.fieldsInjected) {
            for (FieldNode field : this.classNode.fields) {
                field.accept(this.cv);
            }
            this.fieldsInjected = true;
        }
        for (MethodNode method : this.classNode.methods) {
            if (!name.equals(method.name) || !desc.equals(method.desc)) continue;
            return null;
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    public void visitEnd() {
        for (MethodNode method : this.classNode.methods) {
            method.accept((ClassVisitor)new RelocatingClassVisitor(this.cv, this.classNode.name, this.name));
        }
        super.visitEnd();
    }
}

