/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.cosmos.osgi.runtime;

import com.github.veithen.cosmos.osgi.runtime.AbstractBundle;
import com.github.veithen.cosmos.osgi.runtime.ServiceContext;
import com.github.veithen.cosmos.osgi.runtime.ServiceReferenceImpl;
import com.github.veithen.cosmos.osgi.runtime.ServiceRegistry;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

final class Service<S>
implements ServiceRegistration<S> {
    private final ServiceRegistry serviceRegistry;
    private final AbstractBundle bundle;
    private final String[] classes;
    private final ServiceFactory<S> serviceFactory;
    private final Dictionary<String, ?> properties;
    private final Map<AbstractBundle, ServiceContext<S>> contexts = new HashMap<AbstractBundle, ServiceContext<S>>();
    private final ServiceReference<S> reference;

    Service(ServiceRegistry serviceRegistry, AbstractBundle bundle, String[] classes, ServiceFactory<S> serviceFactory, Dictionary<String, ?> properties) {
        this.serviceRegistry = serviceRegistry;
        this.bundle = bundle;
        this.classes = classes;
        this.serviceFactory = serviceFactory;
        this.properties = properties;
        this.reference = new ServiceReferenceImpl<S>(this){

            @Override
            S getService(AbstractBundle bundle) {
                return Service.this.getService(bundle);
            }
        };
    }

    boolean matches(String clazz, Filter filter) {
        if (clazz != null) {
            boolean classMatches = false;
            for (String c : this.classes) {
                if (!c.equals(clazz)) continue;
                classMatches = true;
                break;
            }
            if (!classMatches) {
                return false;
            }
        }
        return filter == null || filter.matchCase(this.properties);
    }

    ServiceFactory<S> getServiceFactory() {
        return this.serviceFactory;
    }

    S getService(AbstractBundle bundle) {
        ServiceContext<S> context = this.contexts.get(bundle);
        if (context == null) {
            context = new ServiceContext(this, bundle);
            this.contexts.put(bundle, context);
        }
        return context.getService();
    }

    Object getProperty(String key) {
        return this.properties == null ? null : this.properties.get(key);
    }

    Bundle getBundle() {
        return this.bundle;
    }

    public ServiceReference<S> getReference() {
        return this.reference;
    }

    <T> ServiceReference<T> getReference(final Class<T> type) {
        return new ServiceReferenceImpl<T>(this){

            @Override
            T getService(AbstractBundle bundle) {
                return type.cast(Service.this.getService(bundle));
            }
        };
    }

    public void setProperties(Dictionary<String, ?> properties) {
        throw new UnsupportedOperationException();
    }

    public void unregister() {
        this.serviceRegistry.unregisterService(this);
    }
}

