/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.cosmos.osgi.runtime;

import com.github.veithen.cosmos.osgi.runtime.AbstractBundle;
import com.github.veithen.cosmos.osgi.runtime.Service;
import com.github.veithen.cosmos.osgi.runtime.ServiceListenerSpec;
import com.github.veithen.cosmos.osgi.runtime.SingletonServiceFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ServiceRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ServiceRegistry.class);
    private final List<Service<?>> services = new LinkedList();
    private final List<ServiceListenerSpec> serviceListeners = new ArrayList<ServiceListenerSpec>();
    private long nextServiceId = 1L;

    ServiceRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <S> Service<S> registerService(AbstractBundle bundle, String[] classes, ServiceFactory<S> serviceFactory, Dictionary<String, ?> properties) {
        long serviceId = this.nextServiceId++;
        if (logger.isDebugEnabled()) {
            Class<?> clazz = serviceFactory instanceof SingletonServiceFactory ? ((SingletonServiceFactory)serviceFactory).getService().getClass() : serviceFactory.getClass();
            logger.debug("Registering service " + clazz.getName() + " with types " + Arrays.asList(classes) + " and properties " + properties + "; id is " + serviceId);
        }
        Hashtable<String, Object> actualProperties = new Hashtable<String, Object>();
        if (properties != null) {
            Enumeration<String> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                actualProperties.put(key, properties.get(key));
            }
        }
        actualProperties.put("objectClass", classes);
        actualProperties.put("service.id", serviceId);
        Service<S> service = new Service<S>(this, bundle, classes, serviceFactory, actualProperties);
        List<Service<?>> list = this.services;
        synchronized (list) {
            this.services.add(service);
        }
        this.fireServiceChangedEvent(1, service);
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterService(Service<?> service) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Unregistering service %s", service.getProperty("service.id")));
        }
        this.fireServiceChangedEvent(4, service);
        List<Service<?>> list = this.services;
        synchronized (list) {
            this.services.remove(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterServices(AbstractBundle bundle) {
        ArrayList servicesToUnregister = new ArrayList();
        List<Service<?>> list = this.services;
        synchronized (list) {
            for (Service<?> service : this.services) {
                if (service.getBundle() != bundle) continue;
                servicesToUnregister.add(service);
            }
        }
        for (Service service : servicesToUnregister) {
            this.unregisterService(service);
        }
    }

    <T> List<ServiceReference<T>> getServiceReferences(String clazz, Filter filter, Class<T> type) {
        ArrayList<ServiceReference<T>> references = new ArrayList<ServiceReference<T>>();
        for (Service<?> service : this.services) {
            if (!service.matches(clazz, filter)) continue;
            references.add(service.getReference(type));
        }
        return references;
    }

    <T> ServiceReference<T> getServiceReference(String clazz, Filter filter, Class<T> type) {
        for (Service<?> service : this.services) {
            if (!service.matches(clazz, filter)) continue;
            return service.getReference(type);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addServiceListener(AbstractBundle bundle, ServiceListener listener, Filter filter) {
        if (logger.isDebugEnabled()) {
            logger.debug("Bundle " + bundle.getSymbolicName() + " starts listening for services with filter " + filter);
        }
        List<ServiceListenerSpec> list = this.serviceListeners;
        synchronized (list) {
            this.serviceListeners.add(new ServiceListenerSpec(listener, filter));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeServiceListener(ServiceListener listener) {
        List<ServiceListenerSpec> list = this.serviceListeners;
        synchronized (list) {
            Iterator<ServiceListenerSpec> it = this.serviceListeners.iterator();
            while (it.hasNext()) {
                if (it.next().getListener() != listener) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireServiceChangedEvent(int type, Service<?> service) {
        ServiceListenerSpec[] serviceListeners;
        List<ServiceListenerSpec> list = this.serviceListeners;
        synchronized (list) {
            serviceListeners = this.serviceListeners.toArray(new ServiceListenerSpec[this.serviceListeners.size()]);
        }
        for (ServiceListenerSpec listener : serviceListeners) {
            if (!service.matches(null, listener.getFilter())) continue;
            listener.getListener().serviceChanged(new ServiceEvent(type, service.getReference()));
        }
    }
}

