/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.cosmos.osgi.runtime;

import com.github.veithen.cosmos.osgi.runtime.ParseException;

final class Tokenizer {
    private static final String whitespace = " \t\n\r";
    private final String s;
    private int index;

    public Tokenizer(String s) {
        this.s = s;
    }

    private void skipWhiteSpace() {
        int len = this.s.length();
        while (this.index < len && whitespace.indexOf(this.s.charAt(this.index)) != -1) {
            ++this.index;
        }
    }

    String getToken(String terminals) {
        int end;
        this.skipWhiteSpace();
        int begin = this.index;
        int len = this.s.length();
        while (this.index < len && terminals.indexOf(this.s.charAt(this.index)) == -1) {
            ++this.index;
        }
        this.skipWhiteSpace();
        for (end = this.index; end > begin && whitespace.indexOf(this.s.charAt(end - 1)) != -1; --end) {
        }
        return this.s.substring(begin, end);
    }

    String getString(String terminals) throws ParseException {
        this.skipWhiteSpace();
        int len = this.s.length();
        if (this.index < len) {
            if (this.s.charAt(this.index) == '\"') {
                StringBuffer sb = new StringBuffer();
                ++this.index;
                while (this.index < len) {
                    char c = this.s.charAt(this.index);
                    if (c == '\\') {
                        ++this.index;
                        if (this.index == len) {
                            throw new ParseException("Expected more input after escape character");
                        }
                        sb.append(this.s.charAt(this.index));
                    } else {
                        if (c == '\"') break;
                        sb.append(c);
                    }
                    ++this.index;
                }
                if (this.index == len) {
                    throw new ParseException("Unclosed quoted string");
                }
                ++this.index;
                this.skipWhiteSpace();
                return sb.toString();
            }
            return this.getToken(terminals);
        }
        return null;
    }

    int getChar() {
        return this.index == this.s.length() ? -1 : (int)this.s.charAt(this.index++);
    }

    boolean skipIf(char c) {
        if (this.index == this.s.length()) {
            return false;
        }
        if (this.s.charAt(this.index) == c) {
            ++this.index;
            return true;
        }
        return false;
    }

    boolean hasMoreTokens() {
        return this.index < this.s.length();
    }
}

