/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.cosmos.osgi.runtime;

import com.github.veithen.cosmos.osgi.runtime.AbstractBundle;
import com.github.veithen.cosmos.osgi.runtime.Service;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ServiceContext<S> {
    private static final Logger logger = LoggerFactory.getLogger(ServiceContext.class);
    private final Service<S> service;
    private final AbstractBundle bundle;
    private int refCount;
    private S serviceObject;

    ServiceContext(Service<S> service, AbstractBundle bundle) {
        this.service = service;
        this.bundle = bundle;
    }

    S getService() {
        if (this.bundle != null && logger.isDebugEnabled()) {
            logger.debug("Bundle " + this.bundle.getSymbolicName() + " is getting service " + this.service.getProperty("service.id"));
        }
        if (this.serviceObject == null) {
            this.serviceObject = this.service.getServiceFactory().getService((Bundle)this.bundle, this.service);
        }
        ++this.refCount;
        return this.serviceObject;
    }
}

