/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.cosmos.p2.maven;

import com.github.veithen.cosmos.osgi.runtime.CosmosRuntime;
import com.github.veithen.cosmos.p2.SystemOutProgressMonitor;
import com.github.veithen.cosmos.p2.maven.RepositoryManager;
import java.io.File;
import java.net.URI;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;

@Component(role=RepositoryManager.class)
public class DefaultRepositoryManager
implements RepositoryManager,
Initializable,
Disposable {
    private IArtifactRepositoryManager repoman;

    public void initialize() throws InitializationException {
        try {
            CosmosRuntime runtime = CosmosRuntime.getInstance();
            IProvisioningAgent agent = ((IProvisioningAgentProvider)runtime.getService(IProvisioningAgentProvider.class)).createAgent(new File("target/p2-data").toURI());
            this.repoman = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        }
        catch (Exception ex) {
            throw new InitializationException("Failed to initialize P2", (Throwable)ex);
        }
    }

    @Override
    public IArtifactRepository loadRepository(URI uri) throws ProvisionException {
        System.out.println("Loading repository " + uri);
        return this.repoman.loadRepository(uri, (IProgressMonitor)new SystemOutProgressMonitor());
    }

    public void dispose() {
    }
}

