/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.cosmos.p2.maven;

import com.github.veithen.cosmos.p2.maven.ProxyDataProvider;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProxyHolder {
    private static final Logger logger = LoggerFactory.getLogger(ProxyHolder.class);
    private static final Object lock = new Object();
    private static ProxyDataProvider currentProxyDataProvider;
    private static List<Lease> leases;

    private ProxyHolder() {
    }

    public static Lease withProxyDataProvider(ProxyDataProvider proxyDataProvider) throws InterruptedException {
        Object object = lock;
        synchronized (object) {
            while (true) {
                boolean proxySet;
                boolean bl = proxySet = !leases.isEmpty();
                if (!proxySet || Objects.equals(currentProxyDataProvider, proxyDataProvider)) {
                    if (proxySet) {
                        logger.debug("Proxy already set");
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug(String.format("Setting proxy %s", proxyDataProvider));
                        }
                        currentProxyDataProvider = proxyDataProvider;
                    }
                    Lease lease = new Lease(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void close() {
                            Object object = lock;
                            synchronized (object) {
                                if (!leases.remove(this)) {
                                    throw new IllegalStateException();
                                }
                                if (leases.isEmpty()) {
                                    logger.debug("Unsetting proxy");
                                    currentProxyDataProvider = null;
                                }
                                lock.notifyAll();
                            }
                        }
                    };
                    leases.add(lease);
                    return lease;
                }
                logger.debug("Another proxy currently set; wait");
                lock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProxyDataProvider getCurrentProxyDataProvider() {
        Object object = lock;
        synchronized (object) {
            return currentProxyDataProvider;
        }
    }

    static {
        leases = new LinkedList<Lease>();
    }

    public static interface Lease
    extends AutoCloseable {
        @Override
        public void close();
    }
}

