/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.cosmos.p2.maven.connector;

import com.github.veithen.cosmos.p2.SystemOutProgressMonitor;
import com.github.veithen.cosmos.p2.maven.ArtifactCoordinateMapper;
import com.github.veithen.cosmos.p2.maven.P2Coordinate;
import com.github.veithen.cosmos.p2.maven.ProxyDataProvider;
import com.github.veithen.cosmos.p2.maven.ProxyHolder;
import com.github.veithen.cosmos.p2.maven.connector.AetherProxyDataProvider;
import com.github.veithen.cosmos.p2.maven.connector.ArtifactHandler;
import com.github.veithen.cosmos.p2.maven.connector.ContentProvider;
import com.github.veithen.cosmos.p2.maven.connector.DOMUtil;
import com.github.veithen.cosmos.p2.maven.connector.DownloadException;
import com.github.veithen.cosmos.p2.maven.connector.JARHandler;
import com.github.veithen.cosmos.p2.maven.connector.POMHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.ArtifactDownload;
import org.eclipse.aether.spi.connector.ArtifactUpload;
import org.eclipse.aether.spi.connector.MetadataDownload;
import org.eclipse.aether.spi.connector.MetadataUpload;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.eclipse.aether.transfer.MetadataNotFoundException;
import org.eclipse.aether.transfer.MetadataTransferException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

final class P2RepositoryConnector
implements RepositoryConnector {
    private static final Logger logger = LoggerFactory.getLogger(P2RepositoryConnector.class);
    private static final Map<String, ArtifactHandler> artifactHandlers = new HashMap<String, ArtifactHandler>();
    private final RemoteRepository repository;
    private final IArtifactRepositoryManager artifactRepositoryManager;
    private IArtifactRepository artifactRepository;

    P2RepositoryConnector(RemoteRepository repository, IArtifactRepositoryManager artifactRepositoryManager) {
        this.repository = repository;
        this.artifactRepositoryManager = artifactRepositoryManager;
    }

    private IArtifactRepository getArtifactRepository() throws DownloadException {
        if (this.artifactRepository == null) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Loading repository %s", this.repository.getUrl()));
            }
            try {
                this.artifactRepository = this.artifactRepositoryManager.loadRepository(new URI(this.repository.getUrl()), (IProgressMonitor)new SystemOutProgressMonitor());
            }
            catch (URISyntaxException | ProvisionException ex) {
                throw new DownloadException(ex);
            }
        }
        return this.artifactRepository;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeFile(File file, ContentProvider contentProvider) throws DownloadException {
        File tmpFile;
        File dir = file.getParentFile();
        if (!dir.isDirectory() && !dir.mkdirs()) {
            throw new DownloadException(String.format("Unable to create directory %s", dir));
        }
        try {
            tmpFile = File.createTempFile(file.getName(), ".tmp", dir);
        }
        catch (IOException ex) {
            throw new DownloadException(String.format("Unable to create temporary file in %s", dir));
        }
        boolean success = false;
        try {
            try (FileOutputStream out = new FileOutputStream(tmpFile);){
                contentProvider.writeTo(out);
            }
            if (!tmpFile.renameTo(file)) {
                throw new DownloadException(String.format("Failed to move file into place (%s)", file));
            }
            success = true;
            if (success || tmpFile.delete()) return;
        }
        catch (IOException ex) {
            try {
                throw new DownloadException(ex);
            }
            catch (Throwable throwable) {
                if (success || tmpFile.delete()) throw throwable;
                logger.error(String.format("Unable to delete temporary file %s", tmpFile));
                throw throwable;
            }
        }
        logger.error(String.format("Unable to delete temporary file %s", tmpFile));
        return;
    }

    private boolean process(ArtifactDownload artifactDownload) throws DownloadException {
        IArtifactRepository artifactRepository;
        IArtifactDescriptor[] descriptors;
        final Artifact artifact = artifactDownload.getArtifact();
        P2Coordinate p2Coordinate = ArtifactCoordinateMapper.createP2Coordinate((Artifact)artifact);
        if (p2Coordinate == null) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Resolving artifact %s...", p2Coordinate));
        }
        if ((descriptors = (artifactRepository = this.getArtifactRepository()).getArtifactDescriptors(p2Coordinate.createIArtifactKey(artifactRepository))).length == 0) {
            logger.debug("Not found");
            return false;
        }
        final IArtifactDescriptor descriptor = descriptors[0];
        String extension = artifact.getExtension();
        final ArtifactHandler artifactHandler = artifactHandlers.get(extension);
        if (artifactHandler == null) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("No handler found for extension %s", extension));
            }
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Using handler of type %s", artifactHandler.getClass().getSimpleName()));
        }
        this.writeFile(artifactDownload.getFile(), new ContentProvider(){

            @Override
            void writeTo(OutputStream out) throws IOException, DownloadException {
                artifactHandler.download(artifact, artifactRepository, descriptor, out);
            }
        });
        logger.debug("Artifact download complete");
        return true;
    }

    private boolean process(MetadataDownload metadataDownload) throws DownloadException {
        Metadata metadata;
        IArtifactRepository artifactRepository = this.getArtifactRepository();
        IQueryResult queryResult = artifactRepository.query((IQuery)ArtifactCoordinateMapper.createArtifactKeyQuery((String)(metadata = metadataDownload.getMetadata()).getGroupId(), (String)metadata.getArtifactId()), (IProgressMonitor)new SystemOutProgressMonitor());
        if (queryResult.isEmpty()) {
            return false;
        }
        final Document document = DOMUtil.createDocument();
        Element metadataElement = document.createElement("metadata");
        document.appendChild(metadataElement);
        Element groupIdElement = document.createElement("groupId");
        groupIdElement.setTextContent(metadata.getGroupId());
        metadataElement.appendChild(groupIdElement);
        Element artifactIdElement = document.createElement("artifactId");
        artifactIdElement.setTextContent(metadata.getArtifactId());
        metadataElement.appendChild(artifactIdElement);
        Element versioningElement = document.createElement("versioning");
        metadataElement.appendChild(versioningElement);
        Element versionsElement = document.createElement("versions");
        versioningElement.appendChild(versionsElement);
        for (IArtifactKey artifactKey : queryResult) {
            Element versionElement = document.createElement("version");
            versionElement.setTextContent(artifactKey.getVersion().toString());
            versionsElement.appendChild(versionElement);
        }
        this.writeFile(metadataDownload.getFile(), new ContentProvider(){

            @Override
            void writeTo(OutputStream out) throws IOException, DownloadException {
                DOMUtil.serialize(document, out);
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(Collection<? extends ArtifactDownload> artifactDownloads, Collection<? extends MetadataDownload> metadataDownloads) {
        ProxyHolder.Lease lease;
        try {
            Proxy proxy = this.repository.getProxy();
            lease = ProxyHolder.withProxyDataProvider((ProxyDataProvider)(proxy == null ? null : new AetherProxyDataProvider(proxy)));
        }
        catch (InterruptedException ex) {
            if (artifactDownloads != null) {
                for (ArtifactDownload artifactDownload : artifactDownloads) {
                    artifactDownload.setException(new ArtifactTransferException(artifactDownload.getArtifact(), this.repository, (Throwable)ex));
                }
            }
            if (metadataDownloads != null) {
                for (MetadataDownload metadataDownload : metadataDownloads) {
                    metadataDownload.setException(new MetadataTransferException(metadataDownload.getMetadata(), this.repository, (Throwable)ex));
                }
            }
            Thread.currentThread().interrupt();
            return;
        }
        try {
            if (artifactDownloads != null) {
                for (ArtifactDownload artifactDownload : artifactDownloads) {
                    try {
                        if (this.process(artifactDownload)) continue;
                        artifactDownload.setException((ArtifactTransferException)new ArtifactNotFoundException(artifactDownload.getArtifact(), this.repository));
                    }
                    catch (DownloadException downloadException) {
                        logger.debug("Caught exception", (Throwable)downloadException);
                        artifactDownload.setException(new ArtifactTransferException(artifactDownload.getArtifact(), this.repository, downloadException.getMessage(), downloadException.getCause()));
                    }
                }
            }
            if (metadataDownloads != null) {
                for (MetadataDownload metadataDownload : metadataDownloads) {
                    try {
                        if (this.process(metadataDownload)) continue;
                        metadataDownload.setException((MetadataTransferException)new MetadataNotFoundException(metadataDownload.getMetadata(), this.repository));
                    }
                    catch (DownloadException downloadException) {
                        logger.debug("Caught exception", (Throwable)downloadException);
                        metadataDownload.setException(new MetadataTransferException(metadataDownload.getMetadata(), this.repository, downloadException.getMessage(), downloadException.getCause()));
                    }
                }
            }
        }
        finally {
            lease.close();
        }
    }

    public void put(Collection<? extends ArtifactUpload> artifactUploads, Collection<? extends MetadataUpload> metadataUploads) {
        if (artifactUploads != null) {
            for (ArtifactUpload artifactUpload : artifactUploads) {
                artifactUpload.setException((ArtifactTransferException)new ArtifactNotFoundException(artifactUpload.getArtifact(), this.repository));
            }
        }
        if (metadataUploads != null) {
            for (MetadataUpload metadataUpload : metadataUploads) {
                metadataUpload.setException((MetadataTransferException)new MetadataNotFoundException(metadataUpload.getMetadata(), this.repository));
            }
        }
    }

    public void close() {
    }

    static {
        artifactHandlers.put("jar", new JARHandler());
        artifactHandlers.put("pom", new POMHandler());
    }
}

