/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.cosmos.p2.maven.connector;

import com.github.veithen.cosmos.p2.maven.connector.ArtifactHandler;
import com.github.veithen.cosmos.p2.maven.connector.DOMUtil;
import com.github.veithen.cosmos.p2.maven.connector.DownloadException;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

final class POMHandler
extends ArtifactHandler {
    private static final String POM_NS = "http://maven.apache.org/POM/4.0.0";

    POMHandler() {
    }

    private static void addPOMElement(Element parent, String name, String content) {
        Element element = parent.getOwnerDocument().createElementNS(POM_NS, name);
        element.setTextContent(content);
        parent.appendChild(element);
    }

    @Override
    void download(Artifact artifact, IArtifactRepository artifactRepository, IArtifactDescriptor descriptor, OutputStream out) throws IOException, DownloadException {
        Document document = DOMUtil.createDocument();
        Element projectElement = document.createElementNS(POM_NS, "project");
        projectElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd");
        document.appendChild(projectElement);
        projectElement.appendChild(document.createComment("Generated dynamically by P2 wagon provider"));
        POMHandler.addPOMElement(projectElement, "modelVersion", "4.0.0");
        POMHandler.addPOMElement(projectElement, "groupId", artifact.getGroupId());
        POMHandler.addPOMElement(projectElement, "artifactId", artifact.getArtifactId());
        POMHandler.addPOMElement(projectElement, "version", artifact.getVersion());
        DOMUtil.serialize(document, out);
    }
}

