/*
 * Decompiled with CFR 0.152.
 */
package waffle.shiro.negotiate;

import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import waffle.servlet.WindowsPrincipal;
import waffle.shiro.negotiate.AuthenticationInProgressException;
import waffle.shiro.negotiate.NegotiateToken;
import waffle.windows.auth.IWindowsAuthProvider;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.IWindowsSecurityContext;
import waffle.windows.auth.impl.WindowsAuthProviderImpl;

public class NegotiateAuthenticationRealm
extends AuthenticatingRealm {
    private static final Logger LOGGER = LoggerFactory.getLogger(NegotiateAuthenticationRealm.class);
    private final IWindowsAuthProvider windowsAuthProvider = new WindowsAuthProviderImpl();

    public boolean supports(AuthenticationToken token) {
        return token instanceof NegotiateToken;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken t) {
        IWindowsSecurityContext securityContext;
        NegotiateToken token = (NegotiateToken)t;
        byte[] inToken = token.getIn();
        if (token.isNtlmPost()) {
            this.windowsAuthProvider.resetSecurityToken(token.getConnectionId());
        }
        try {
            securityContext = this.windowsAuthProvider.acceptSecurityToken(token.getConnectionId(), inToken, token.getSecurityPackage());
        }
        catch (Exception e) {
            LOGGER.warn("error logging in user");
            throw new AuthenticationException((Throwable)e);
        }
        byte[] continueTokenBytes = securityContext.getToken();
        token.setOut(continueTokenBytes);
        if (continueTokenBytes != null) {
            LOGGER.debug("continue token bytes: {}", (Object)continueTokenBytes.length);
        } else {
            LOGGER.debug("no continue token bytes");
        }
        if (securityContext.isContinue() || token.isNtlmPost()) {
            throw new AuthenticationInProgressException();
        }
        IWindowsIdentity windowsIdentity = securityContext.getIdentity();
        securityContext.dispose();
        LOGGER.debug("logged in user: {} ({})", (Object)windowsIdentity.getFqn(), (Object)windowsIdentity.getSidString());
        WindowsPrincipal principal = new WindowsPrincipal(windowsIdentity);
        token.setPrincipal((Principal)principal);
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)principal);
        token.setSubject(subject);
        return token.createInfo();
    }
}

