/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.flattener;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.apache.commons.text.translate.CharSequenceTranslator;

class ObjectMapperFactory {
    private static final ObjectMapperFactory INSTANCE = new ObjectMapperFactory();
    private final ObjectMapper mapper = new ObjectMapper();

    private ObjectMapperFactory() {
    }

    public static ObjectMapper get() {
        return ObjectMapperFactory.INSTANCE.mapper;
    }

    public static ObjectMapper getWriter() {
        ObjectMapper mapper = new ObjectMapper();
        JsonSerializer<String> js = new JsonSerializer<String>(){

            public void serialize(String value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeRawValue("\"" + value + "\"");
            }
        };
        SimpleModule module = new SimpleModule();
        module.addSerializer(String.class, (JsonSerializer)js);
        mapper.registerModule((Module)module);
        return mapper;
    }

    public static ObjectMapper get(CharSequenceTranslator translator) {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(String.class, ObjectMapperFactory.getDeserializer(translator));
        mapper.registerModule((Module)module);
        return mapper;
    }

    private static JsonDeserializer<String> getDeserializer(final CharSequenceTranslator translator) {
        return new JsonDeserializer<String>(){

            public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                return translator.translate((CharSequence)p.getValueAsString());
            }
        };
    }
}

