/*
 * Decompiled with CFR 0.152.
 */
package com.github.x25.net;

public class Utils {
    public static byte[] ipAddrToBytes(String ipStr) {
        byte[] result = new byte[4];
        long b = 0L;
        int q = 0;
        if (ipStr.length() <= 0 || ipStr.length() > 15) {
            return null;
        }
        for (int i = 0; i < ipStr.length(); ++i) {
            if (ipStr.charAt(i) == '.') {
                if (b < 0L || b > 255L || q == 3) {
                    return null;
                }
                result[q++] = (byte)(b & 0xFFL);
                b = 0L;
                continue;
            }
            int d = Character.digit(ipStr.charAt(i), 10);
            if (d < 0) {
                return null;
            }
            b *= 10L;
            b += (long)d;
        }
        if (b >= 0L && b < 1L << (4 - q) * 8) {
            switch (q) {
                case 0: {
                    result[0] = (byte)(b >> 24 & 0xFFL);
                }
                case 1: {
                    result[1] = (byte)(b >> 16 & 0xFFL);
                }
                case 2: {
                    result[2] = (byte)(b >> 8 & 0xFFL);
                }
                case 3: {
                    result[3] = (byte)(b & 0xFFL);
                }
            }
            return result;
        }
        return null;
    }

    public static int ipAddrToInt(String ipStr) {
        byte[] bytes = Utils.ipAddrToBytes(ipStr);
        if (bytes == null) {
            throw new IllegalArgumentException("Could not parse [" + ipStr + "]");
        }
        int ret = 0;
        for (int i = 0; i < 4 && i < bytes.length; ++i) {
            ret <<= 8;
            ret |= bytes[i] & 0xFF;
        }
        return ret;
    }

    public static String intToIpAddr(int ip) {
        return "" + String.valueOf(ip >>> 24) + "." + String.valueOf((ip & 0xFFFFFF) >>> 16) + "." + String.valueOf((ip & 0xFFFF) >>> 8) + "." + String.valueOf(ip & 0xFF);
    }
}

