/*
 * Decompiled with CFR 0.152.
 */
package gui.ava.html.image.generator;

import gui.ava.html.image.util.FormatNameUtil;
import gui.ava.html.image.util.SynchronousHTMLEditorKit;
import gui.ava.html.link.LinkHarvester;
import gui.ava.html.link.LinkInfo;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JEditorPane;

public class HtmlImageGenerator {
    private JEditorPane editorPane = this.createJEditorPane();
    static final Dimension DEFAULT_SIZE = new Dimension(800, 800);

    public ComponentOrientation getOrientation() {
        return this.editorPane.getComponentOrientation();
    }

    public void setOrientation(ComponentOrientation componentOrientation) {
        this.editorPane.setComponentOrientation(componentOrientation);
    }

    public Dimension getSize() {
        return this.editorPane.getSize();
    }

    public void setSize(Dimension dimension) {
        this.editorPane.setSize(dimension);
    }

    public void loadUrl(URL uRL) {
        try {
            this.editorPane.setPage(uRL);
        }
        catch (IOException iOException) {
            throw new RuntimeException(String.format("Exception while loading %s", uRL), iOException);
        }
    }

    public void loadUrl(String string) {
        try {
            this.editorPane.setPage(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException(String.format("Exception while loading %s", string), iOException);
        }
    }

    public void loadHtml(String string) {
        this.editorPane.setText(string);
        this.onDocumentLoad();
    }

    public String getLinksMapMarkup(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<map name=\"").append(string).append("\">\n");
        for (LinkInfo linkInfo : this.getLinks()) {
            List<Rectangle> list = linkInfo.getBounds();
            for (Rectangle rectangle : list) {
                int n = (int)rectangle.getX();
                int n2 = (int)rectangle.getY();
                int n3 = (int)((double)n + rectangle.getWidth());
                int n4 = (int)((double)n2 + rectangle.getHeight());
                stringBuilder.append(String.format("<area coords=\"%s,%s,%s,%s\" shape=\"rect\"", n, n2, n3, n4));
                for (Map.Entry<String, String> entry : linkInfo.getAttributes().entrySet()) {
                    String string2 = entry.getKey();
                    String string3 = entry.getValue();
                    stringBuilder.append(" ").append(string2).append("=\"").append(string3.replace("\"", "&quot;")).append("\"");
                }
                stringBuilder.append(">\n");
            }
        }
        stringBuilder.append("</map>\n");
        return stringBuilder.toString();
    }

    public List<LinkInfo> getLinks() {
        LinkHarvester linkHarvester = new LinkHarvester(this.editorPane);
        return linkHarvester.getLinks();
    }

    public void saveAsHtmlWithMap(String string, String string2) {
        this.saveAsHtmlWithMap(new File(string), string2);
    }

    public void saveAsHtmlWithMap(File file, String string) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            fileWriter.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n");
            fileWriter.append("<html>\n<head></head>\n");
            fileWriter.append("<body style=\"margin: 0; padding: 0; text-align: center;\">\n");
            String string2 = this.getLinksMapMarkup("map");
            fileWriter.write(string2);
            fileWriter.append("<img border=\"0\" usemap=\"#map\" src=\"");
            fileWriter.append(string);
            fileWriter.append("\"/>\n");
            fileWriter.append("</body>\n</html>");
        }
        catch (IOException iOException) {
            throw new RuntimeException(String.format("Exception while saving '%s' html file", file), iOException);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void saveAsImage(String string) {
        this.saveAsImage(new File(string));
    }

    public void saveAsImage(File file) {
        BufferedImage bufferedImage = this.getBufferedImage();
        try {
            String string = FormatNameUtil.formatForFilename(file.getName());
            ImageIO.write((RenderedImage)bufferedImage, string, file);
        }
        catch (IOException iOException) {
            throw new RuntimeException(String.format("Exception while saving '%s' image", file), iOException);
        }
    }

    protected void onDocumentLoad() {
    }

    public Dimension getDefaultSize() {
        return DEFAULT_SIZE;
    }

    public BufferedImage getBufferedImage() {
        Dimension dimension = this.editorPane.getPreferredSize();
        BufferedImage bufferedImage = new BufferedImage(dimension.width, this.editorPane.getPreferredSize().height, 2);
        Graphics graphics = bufferedImage.getGraphics();
        this.editorPane.setSize(dimension);
        this.editorPane.paint(graphics);
        return bufferedImage;
    }

    protected JEditorPane createJEditorPane() {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setSize(this.getDefaultSize());
        jEditorPane.setEditable(false);
        SynchronousHTMLEditorKit synchronousHTMLEditorKit = new SynchronousHTMLEditorKit();
        jEditorPane.setEditorKitForContentType("text/html; charset=UTF-8", synchronousHTMLEditorKit);
        jEditorPane.setContentType("text/html; charset=UTF-8");
        jEditorPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("page")) {
                    HtmlImageGenerator.this.onDocumentLoad();
                }
            }
        });
        return jEditorPane;
    }
}

