/*
 * Decompiled with CFR 0.152.
 */
package com.github.ywilkof.sparkrestclient;

import com.github.ywilkof.sparkrestclient.DriverState;
import com.github.ywilkof.sparkrestclient.FailedSparkRequestException;
import com.github.ywilkof.sparkrestclient.HttpRequestUtil;
import com.github.ywilkof.sparkrestclient.JobStatusResponse;
import com.github.ywilkof.sparkrestclient.SparkRestClient;
import com.github.ywilkof.sparkrestclient.interfaces.CanValidateSubmissionId;
import com.github.ywilkof.sparkrestclient.interfaces.JobStatusRequestSpecification;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

public class JobStatusRequestSpecificationImpl
implements JobStatusRequestSpecification,
CanValidateSubmissionId {
    private SparkRestClient sparkRestClient;

    public JobStatusRequestSpecificationImpl(SparkRestClient sparkRestClient) {
        this.sparkRestClient = sparkRestClient;
    }

    @Override
    public DriverState withSubmissionId(String submissionId) throws FailedSparkRequestException {
        JobStatusResponse response = this.withSubmissionIdFullResponse(submissionId);
        return response.getDriverState();
    }

    @Override
    public JobStatusResponse withSubmissionIdFullResponse(String submissionId) throws FailedSparkRequestException {
        this.assertSubmissionId(submissionId);
        String url = this.sparkRestClient.getHttpScheme() + "://" + this.sparkRestClient.getMasterUrl() + "/v1/submissions/status/" + submissionId;
        JobStatusResponse response = HttpRequestUtil.executeHttpMethodAndGetResponse(this.sparkRestClient.getClient(), (HttpRequestBase)new HttpGet(url), JobStatusResponse.class);
        if (!response.getSuccess().booleanValue()) {
            throw new FailedSparkRequestException("submit was not successful.", response.getDriverState());
        }
        return response;
    }
}

