/*
 * Decompiled with CFR 0.152.
 */
package com.github.ywilkof.sparkrestclient;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.github.ywilkof.sparkrestclient.Action;
import com.github.ywilkof.sparkrestclient.FailedSparkRequestException;
import com.github.ywilkof.sparkrestclient.HttpRequestUtil;
import com.github.ywilkof.sparkrestclient.JobSubmitRequest;
import com.github.ywilkof.sparkrestclient.MapperWrapper;
import com.github.ywilkof.sparkrestclient.SparkResponse;
import com.github.ywilkof.sparkrestclient.SparkRestClient;
import com.github.ywilkof.sparkrestclient.interfaces.JobSubmitRequestSpecification;
import com.github.ywilkof.sparkrestclient.interfaces.SparkPropertiesSpecification;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;

public class JobSubmitRequestSpecificationImpl
implements JobSubmitRequestSpecification {
    private static final String CONTENT_TYPE_HEADER = "content-type";
    private static final String MIME_TYPE_JSON = "application/json";
    private static final String CHARSET_UTF_8 = "charset=UTF-8";
    private static final String MIME_TYPE_JSON_UTF_8 = "application/json;charset=UTF-8";
    private String appResource;
    private List<String> appArgs;
    private String mainClass;
    private String appName;
    private Set<String> jars;
    private SparkRestClient sparkRestClient;
    private Map<String, String> props = new HashMap<String, String>();

    public JobSubmitRequestSpecificationImpl(SparkRestClient sparkRestClient) {
        this.sparkRestClient = sparkRestClient;
    }

    @Override
    public JobSubmitRequestSpecification appResource(String appResource) {
        this.appResource = appResource;
        return this;
    }

    @Override
    public JobSubmitRequestSpecification appArgs(List<String> appArgs) {
        this.appArgs = appArgs;
        return this;
    }

    @Override
    public JobSubmitRequestSpecification mainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    @Override
    public JobSubmitRequestSpecification appName(String appName) {
        this.appName = appName;
        return this;
    }

    @Override
    public JobSubmitRequestSpecification usingJars(Set<String> jars) {
        this.jars = jars;
        return this;
    }

    @Override
    public SparkPropertiesSpecification withProperties() {
        return new SparkPropertiesSpecificationImpl();
    }

    @Override
    public String submit() throws FailedSparkRequestException {
        if (this.mainClass == null || this.appResource == null) {
            throw new IllegalArgumentException("mainClass and appResource values must not be null");
        }
        JobSubmitRequest jobSubmitRequest = JobSubmitRequest.builder().action(Action.CreateSubmissionRequest).appArgs(this.appArgs == null ? Collections.emptyList() : this.appArgs).appResource(this.appResource).clientSparkVersion(this.sparkRestClient.getSparkVersion()).mainClass(this.mainClass).environmentVariables(this.sparkRestClient.getEnvironmentVariables()).sparkProperties(JobSubmitRequest.SparkProperties.builder().jars(this.jars(this.appResource, this.jars)).appName(this.appName).master((Object)((Object)this.sparkRestClient.getClusterMode()) + "://" + this.sparkRestClient.getMasterUrl()).otherProperties(this.props).build()).build();
        String url = this.sparkRestClient.getHttpScheme() + "://" + this.sparkRestClient.getMasterUrl() + "/v1/submissions/create";
        HttpPost post = new HttpPost(url);
        post.setHeader("Content-Type", MIME_TYPE_JSON_UTF_8);
        try {
            String message = MapperWrapper.MAPPER.writeValueAsString((Object)jobSubmitRequest);
            post.setEntity((HttpEntity)new StringEntity(message));
        }
        catch (JsonProcessingException | UnsupportedEncodingException e) {
            throw new FailedSparkRequestException(e);
        }
        SparkResponse response = HttpRequestUtil.executeHttpMethodAndGetResponse(this.sparkRestClient.getClient(), (HttpRequestBase)post, SparkResponse.class);
        if (!response.getSuccess().booleanValue()) {
            throw new FailedSparkRequestException("submit was not successful.");
        }
        return response.getSubmissionId();
    }

    String jars(String appResource, Set<String> jars) {
        Set output = Stream.of(appResource).collect(Collectors.toSet());
        Optional.ofNullable(jars).ifPresent(j -> output.addAll(j));
        return String.join((CharSequence)",", new TreeSet(output));
    }

    String getAppResource() {
        return this.appResource;
    }

    List<String> getAppArgs() {
        return this.appArgs;
    }

    String getMainClass() {
        return this.mainClass;
    }

    String getAppName() {
        return this.appName;
    }

    Set<String> getJars() {
        return this.jars;
    }

    SparkRestClient getSparkRestClient() {
        return this.sparkRestClient;
    }

    Map<String, String> getProps() {
        return this.props;
    }

    void setAppResource(String appResource) {
        this.appResource = appResource;
    }

    void setAppArgs(List<String> appArgs) {
        this.appArgs = appArgs;
    }

    void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    void setAppName(String appName) {
        this.appName = appName;
    }

    void setJars(Set<String> jars) {
        this.jars = jars;
    }

    void setSparkRestClient(SparkRestClient sparkRestClient) {
        this.sparkRestClient = sparkRestClient;
    }

    void setProps(Map<String, String> props) {
        this.props = props;
    }

    public class SparkPropertiesSpecificationImpl
    implements SparkPropertiesSpecification {
        @Override
        public SparkPropertiesSpecification put(String sparkProperty, String value) {
            JobSubmitRequestSpecificationImpl.this.props.put(sparkProperty, value);
            return this;
        }

        @Override
        public String submit() throws FailedSparkRequestException {
            return JobSubmitRequestSpecificationImpl.this.submit();
        }
    }
}

