/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.beyondcorp.appgateways.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AppGatewayName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_APP_GATEWAY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/appGateways/{app_gateway}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String appGateway;

    @Deprecated
    protected AppGatewayName() {
        this.project = null;
        this.location = null;
        this.appGateway = null;
    }

    private AppGatewayName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.appGateway = (String)Preconditions.checkNotNull((Object)builder.getAppGateway());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAppGateway() {
        return this.appGateway;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AppGatewayName of(String project, String location, String appGateway) {
        return AppGatewayName.newBuilder().setProject(project).setLocation(location).setAppGateway(appGateway).build();
    }

    public static String format(String project, String location, String appGateway) {
        return AppGatewayName.newBuilder().setProject(project).setLocation(location).setAppGateway(appGateway).build().toString();
    }

    public static AppGatewayName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_APP_GATEWAY.validatedMatch(formattedString, "AppGatewayName.parse: formattedString not in valid format");
        return AppGatewayName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("app_gateway"));
    }

    public static List<AppGatewayName> parseList(List<String> formattedStrings) {
        ArrayList<AppGatewayName> list = new ArrayList<AppGatewayName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AppGatewayName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AppGatewayName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AppGatewayName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_APP_GATEWAY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AppGatewayName appGatewayName = this;
            synchronized (appGatewayName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.appGateway != null) {
                        fieldMapBuilder.put((Object)"app_gateway", (Object)this.appGateway);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_APP_GATEWAY.instantiate(new String[]{"project", this.project, "location", this.location, "app_gateway", this.appGateway});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AppGatewayName that = (AppGatewayName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.appGateway, that.appGateway);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.appGateway);
    }

    public static class Builder {
        private String project;
        private String location;
        private String appGateway;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAppGateway() {
            return this.appGateway;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAppGateway(String appGateway) {
            this.appGateway = appGateway;
            return this;
        }

        private Builder(AppGatewayName appGatewayName) {
            this.project = appGatewayName.project;
            this.location = appGatewayName.location;
            this.appGateway = appGatewayName.appGateway;
        }

        public AppGatewayName build() {
            return new AppGatewayName(this);
        }
    }
}

