/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.users;

import com.google.appengine.api.users.User;
import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFailureException;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.UserServicePb;

final class UserServiceImpl
implements UserService {
    private static final String PACKAGE = "user";
    private static final String LOGIN_URL_METHOD = "CreateLoginURL";
    private static final String LOGOUT_URL_METHOD = "CreateLogoutURL";

    UserServiceImpl() {
    }

    public String createLoginURL(String destinationURL) {
        return this.doCreateURL(LOGIN_URL_METHOD, destinationURL);
    }

    public String createLogoutURL(String destinationURL) {
        return this.doCreateURL(LOGOUT_URL_METHOD, destinationURL);
    }

    public boolean isUserLoggedIn() {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        return environment.isLoggedIn();
    }

    public boolean isUserAdmin() {
        if (this.isUserLoggedIn()) {
            return ApiProxy.getCurrentEnvironment().isAdmin();
        }
        throw new IllegalStateException("The current user is not logged in.");
    }

    public User getCurrentUser() {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        if (environment.isLoggedIn()) {
            return new User(environment.getEmail(), environment.getAuthDomain());
        }
        return null;
    }

    private String doCreateURL(String methodName, String destinationURL) {
        byte[] responseBytes;
        ApiBasePb.StringProto request = new ApiBasePb.StringProto();
        request.setValue(destinationURL);
        try {
            byte[] requestBytes = request.toByteArray();
            responseBytes = ApiProxy.makeSyncCall(PACKAGE, methodName, requestBytes);
        }
        catch (ApiProxy.ApplicationException ex) {
            UserServicePb.UserServiceError.ErrorCode errorCode = UserServicePb.UserServiceError.ErrorCode.valueOf(ex.getApplicationError());
            switch (errorCode) {
                case REDIRECT_URL_TOO_LONG: {
                    throw new IllegalArgumentException("URL too long: " + destinationURL);
                }
            }
            throw new UserServiceFailureException(ex.getErrorDetail());
        }
        ApiBasePb.StringProto response = new ApiBasePb.StringProto();
        response.mergeFrom(responseBytes);
        return response.getValue();
    }
}

