/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Comparators;
import com.google.appengine.repackaged.com.google.common.collect.Iterators;
import com.google.common.base.Nullable;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SortedArraySet<E>
extends AbstractSet<E>
implements SortedSet<E>,
Serializable {
    private ArrayList<E> contents;
    private final Comparator<? super E> comparator;
    private static final long serialVersionUID = 0L;

    public SortedArraySet() {
        this(10);
    }

    public SortedArraySet(int initialCapacity) {
        Preconditions.checkArgument(initialCapacity >= 0);
        this.comparator = SortedArraySet.orNaturalOrder(null);
        if (initialCapacity > 0) {
            this.contents = new ArrayList(initialCapacity);
        }
    }

    public SortedArraySet(Comparator<? super E> comparator) {
        this(comparator, 10);
    }

    public SortedArraySet(Comparator<? super E> comparator, int initialCapacity) {
        Preconditions.checkNotNull(comparator);
        this.comparator = comparator;
        if (initialCapacity > 0) {
            this.contents = new ArrayList(initialCapacity);
        }
    }

    public SortedArraySet(Collection<? extends E> collection) {
        this.comparator = collection instanceof SortedSet ? SortedArraySet.orNaturalOrder(((SortedSet)collection).comparator()) : SortedArraySet.orNaturalOrder(null);
        this.addAll(collection);
    }

    public SortedArraySet(SortedSet<E> set) {
        this.comparator = SortedArraySet.orNaturalOrder(set.comparator());
        this.addAll(set);
    }

    public void ensureCapacity(int minCapacity) {
        if (this.contents == null) {
            if (minCapacity > 0) {
                this.contents = new ArrayList(minCapacity);
            }
        } else {
            this.contents.ensureCapacity(minCapacity);
        }
    }

    public void trimToSize() {
        if (this.size() == 0) {
            this.contents = null;
        } else {
            this.contents.trimToSize();
        }
    }

    @Override
    public boolean add(E o) {
        if (this.contents == null) {
            this.contents = new ArrayList(1);
            this.contents.add(o);
            return true;
        }
        int pos = this.binarySearch(o);
        if (pos < 0) {
            this.contents.add(-pos - 1, o);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if ((this.contents == null || this.contents.isEmpty()) && !c.isEmpty() && c instanceof SortedSet) {
            Comparator comparator2 = ((SortedSet)c).comparator();
            if (this.comparator == Comparators.naturalOrder() && comparator2 == null || this.comparator == comparator2) {
                if (this.contents == null) {
                    this.contents = new ArrayList<E>(c);
                } else {
                    this.contents.addAll(c);
                }
                return true;
            }
        }
        return super.addAll(c);
    }

    @Override
    public void clear() {
        this.contents = null;
    }

    @Override
    public boolean contains(@Nullable Object o) {
        if (o == null && this.comparator == Comparators.naturalOrder()) {
            return false;
        }
        try {
            return this.binarySearch(o) >= 0;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SortedArraySet) {
            SortedArraySet set = (SortedArraySet)o;
            if (Objects.equal(this.comparator, set.comparator)) {
                int n = this.size();
                return n == set.size() && (n == 0 || this.contents.equals(set.contents));
            }
        }
        return super.equals(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.contents == null ? Iterators.emptyModifiableIterator() : this.contents.iterator();
    }

    @Override
    public boolean remove(@Nullable Object o) {
        int pos;
        if (o == null && this.comparator == Comparators.naturalOrder()) {
            return false;
        }
        try {
            pos = this.binarySearch(o);
        }
        catch (NullPointerException e) {
            return false;
        }
        if (pos < 0) {
            return false;
        }
        this.contents.remove(pos);
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return super.retainAll(Preconditions.checkNotNull(c));
    }

    @Override
    public int size() {
        return this.contents == null ? 0 : this.contents.size();
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        Preconditions.checkArgument(this.comparator.compare(toElement, fromElement) >= 0);
        return new SubSet(fromElement, toElement, true, true);
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return new SubSet(null, toElement, false, true);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return new SubSet(fromElement, null, true, false);
    }

    @Override
    public E first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get(0);
    }

    @Override
    public E last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get(this.size() - 1);
    }

    private int binarySearch(Object o) {
        if (this.contents == null) {
            return -1;
        }
        Object e = o;
        return Collections.binarySearch(this.contents, e, this.comparator);
    }

    private E get(int index) {
        if (this.contents == null) {
            throw new NoSuchElementException();
        }
        try {
            return this.contents.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    private static <E> Comparator<? super E> orNaturalOrder(@Nullable Comparator<? super E> comparator) {
        if (comparator != null) {
            return comparator;
        }
        return Comparators.naturalOrder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubSet
    extends AbstractSet<E>
    implements SortedSet<E> {
        final E head;
        final E tail;
        final boolean hasHead;
        final boolean hasTail;

        SubSet(@Nullable E fromElement, E toElement, boolean hasHead, boolean hasTail) {
            this.head = fromElement;
            this.tail = toElement;
            this.hasHead = hasHead;
            this.hasTail = hasTail;
        }

        int headIndex() {
            if (!this.hasHead) {
                return 0;
            }
            int pos = SortedArraySet.this.binarySearch(this.head);
            return pos < 0 ? -pos - 1 : pos;
        }

        int tailIndex() {
            if (SortedArraySet.this.contents == null) {
                return 0;
            }
            if (!this.hasTail) {
                return SortedArraySet.this.contents.size();
            }
            int pos = SortedArraySet.this.binarySearch(this.tail);
            return pos < 0 ? -pos - 1 : pos;
        }

        void checkHead(E fromElement) {
            if (this.hasHead) {
                Preconditions.checkArgument(SortedArraySet.this.comparator.compare(fromElement, this.head) >= 0);
            }
        }

        void checkTail(E toElement) {
            if (this.hasTail) {
                Preconditions.checkArgument(SortedArraySet.this.comparator.compare(this.tail, toElement) > 0);
            }
        }

        @Override
        public int size() {
            return this.tailIndex() - this.headIndex();
        }

        @Override
        public Comparator<? super E> comparator() {
            return SortedArraySet.this.comparator;
        }

        @Override
        public Iterator<E> iterator() {
            return SortedArraySet.this.contents == null ? Iterators.emptyIterator() : SortedArraySet.this.contents.subList(this.headIndex(), this.tailIndex()).iterator();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Object e = o;
                if (this.hasHead && SortedArraySet.this.comparator.compare(e, this.head) < 0 || this.hasTail && SortedArraySet.this.comparator.compare(this.tail, e) <= 0) {
                    return false;
                }
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
            return SortedArraySet.this.contains(o);
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            Preconditions.checkArgument(SortedArraySet.this.comparator.compare(toElement, fromElement) >= 0);
            this.checkHead(fromElement);
            this.checkTail(toElement);
            return new SubSet(fromElement, toElement, true, true);
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            this.checkHead(toElement);
            this.checkTail(toElement);
            return new SubSet(this.head, toElement, this.hasHead, true);
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            this.checkHead(fromElement);
            this.checkTail(fromElement);
            return new SubSet(fromElement, this.tail, true, this.hasTail);
        }

        @Override
        public E first() {
            Object o = SortedArraySet.this.get(this.headIndex());
            if (this.hasTail && SortedArraySet.this.comparator.compare(this.tail, o) <= 0) {
                throw new NoSuchElementException();
            }
            return o;
        }

        @Override
        public E last() {
            Object o = SortedArraySet.this.get(this.tailIndex() - 1);
            if (this.hasHead && SortedArraySet.this.comparator.compare(o, this.head) < 0) {
                throw new NoSuchElementException();
            }
            return o;
        }
    }
}

