/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.protocol;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.UninterpretedTags;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProtocolSupport {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final String UNINTERPRETED_TAGS_FIELD = "uninterpreted";
    private static final int ENSURE_CAPACITY_EXTRA = 10;
    private static final int[] FROZEN_INT_ARRAY = new int[0];
    private static final long[] FROZEN_LONG_ARRAY = new long[0];
    private static final float[] FROZEN_FLOAT_ARRAY = new float[0];
    private static final double[] FROZEN_DOUBLE_ARRAY = new double[0];
    private static final boolean[] FROZEN_BOOLEAN_ARRAY = new boolean[0];

    public static <T> T unsupportedOperation() {
        throw new UnsupportedOperationException("Modifying immutable object");
    }

    public static int hashCode(boolean b) {
        return b ? 1 : 0;
    }

    public static int hashCode(int i) {
        return i;
    }

    public static int hashCode(long l) {
        return (int)(l + (l >>> 32));
    }

    public static int hashCode(float f) {
        return Float.floatToIntBits(f);
    }

    public static int hashCode(double d) {
        long l = Double.doubleToLongBits(d);
        return (int)(l + (l >>> 32));
    }

    public static <T> T[] growArray(T[] array) {
        return Arrays.copyOf(array, Math.max(4, array.length * 2));
    }

    public static boolean[] growArray(boolean[] array) {
        return Arrays.copyOf(array, Math.max(4, array.length * 2));
    }

    public static int[] growArray(int[] array) {
        return Arrays.copyOf(array, Math.max(4, array.length * 2));
    }

    public static long[] growArray(long[] array) {
        return Arrays.copyOf(array, Math.max(4, array.length * 2));
    }

    public static float[] growArray(float[] array) {
        return Arrays.copyOf(array, Math.max(4, array.length * 2));
    }

    public static double[] growArray(double[] array) {
        return Arrays.copyOf(array, Math.max(4, array.length * 2));
    }

    public static <T> T[] ensureCapacity(T[] array, int size) {
        if (size > array.length) {
            return Arrays.copyOf(array, size + 10);
        }
        return array;
    }

    public static boolean[] ensureCapacity(boolean[] array, int size) {
        if (size > array.length) {
            return Arrays.copyOf(array, size + 10);
        }
        return array;
    }

    public static int[] ensureCapacity(int[] array, int size) {
        if (size > array.length) {
            return Arrays.copyOf(array, size + 10);
        }
        return array;
    }

    public static long[] ensureCapacity(long[] array, int size) {
        if (size > array.length) {
            return Arrays.copyOf(array, size + 10);
        }
        return array;
    }

    public static float[] ensureCapacity(float[] array, int size) {
        if (size > array.length) {
            return Arrays.copyOf(array, size + 10);
        }
        return array;
    }

    public static double[] ensureCapacity(double[] array, int size) {
        if (size > array.length) {
            return Arrays.copyOf(array, size + 10);
        }
        return array;
    }

    public static List<Integer> asList(final int[] array, final int start, final int end) {
        return new AbstractList<Integer>(){
            private int listSize;
            {
                this.listSize = end - start;
            }

            @Override
            public int size() {
                return this.listSize;
            }

            @Override
            public Integer get(int i) {
                if (i < 0 || i >= this.listSize) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return array[i + start];
            }
        };
    }

    public static List<Long> asList(final long[] array, final int start, final int end) {
        return new AbstractList<Long>(){
            private int listSize;
            {
                this.listSize = end - start;
            }

            @Override
            public int size() {
                return this.listSize;
            }

            @Override
            public Long get(int i) {
                if (i < 0 || i >= this.listSize) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return array[i + start];
            }
        };
    }

    public static List<Float> asList(final float[] array, final int start, final int end) {
        return new AbstractList<Float>(){
            private int listSize;
            {
                this.listSize = end - start;
            }

            @Override
            public int size() {
                return this.listSize;
            }

            @Override
            public Float get(int i) {
                if (i < 0 || i >= this.listSize) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return Float.valueOf(array[i + start]);
            }
        };
    }

    public static List<Double> asList(final double[] array, final int start, final int end) {
        return new AbstractList<Double>(){
            private int listSize;
            {
                this.listSize = end - start;
            }

            @Override
            public int size() {
                return this.listSize;
            }

            @Override
            public Double get(int i) {
                if (i < 0 || i >= this.listSize) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return array[i + start];
            }
        };
    }

    public static List<Boolean> asList(final boolean[] array, final int start, final int end) {
        return new AbstractList<Boolean>(){
            private int listSize;
            {
                this.listSize = end - start;
            }

            @Override
            public int size() {
                return this.listSize;
            }

            @Override
            public Boolean get(int i) {
                if (i < 0 || i >= this.listSize) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return array[i + start];
            }
        };
    }

    public static Iterator<String> byteArrayToUnicodeIterator(List<byte[]> data) {
        return ByteArrayToUnicodeFunction.getInstance().asList(data).iterator();
    }

    public static Iterator<String> byteArrayToUnicodeIterator(List<byte[]> data, Charset cs) {
        return ByteArrayToUnicodeFunction.getInstance(cs).asList(data).iterator();
    }

    public static List<String> byteArrayToUnicodeList(List<byte[]> data) {
        return ByteArrayToUnicodeFunction.getInstance().asList(data);
    }

    public static List<String> byteArrayToUnicodeList(List<byte[]> data, Charset cs) {
        return ByteArrayToUnicodeFunction.getInstance(cs).asList(data);
    }

    public static byte[] toBytes(String str, Charset charset) {
        try {
            return str != null ? str.getBytes(charset.name()) : null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Charset " + charset + " not supported by JVM: ", e);
        }
    }

    public static byte[] toBytesUtf8(String str) {
        try {
            return str != null ? str.getBytes("UTF-8") : null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toString(byte[] data, Charset charset) {
        try {
            return data != null ? new String(data, charset.name()) : null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Charset " + charset + " not supported by JVM: ", e);
        }
    }

    public static String toStringUtf8(byte[] data) {
        return ProtocolSupport.toStringUtf8(data, 0, data.length);
    }

    public static String toStringUtf8(byte[] data, int offset, int length) {
        try {
            return data != null ? new String(data, offset, length, "UTF-8") : null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends ProtocolMessage> T newInstance(Class<T> clazz) {
        try {
            return (T)((ProtocolMessage)clazz.newInstance());
        }
        catch (InstantiationException e) {
            if (clazz == ProtocolMessage.class) {
                throw new IllegalArgumentException("ProtocolMessage.class cannot be instantiated");
            }
            throw new AssertionError((Object)"Protocol messages should always be instantiable");
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)"Protocol messages constructors should always be public");
        }
    }

    public static UninterpretedTags getUninterpreted(ProtocolMessage pb) {
        if (pb == null) {
            return null;
        }
        Class<?> clazz = pb.getClass();
        try {
            Field utagsField = clazz.getDeclaredField(UNINTERPRETED_TAGS_FIELD);
            utagsField.setAccessible(true);
            UninterpretedTags utags = (UninterpretedTags)utagsField.get(pb);
            if (utags == null) {
                return null;
            }
            UninterpretedTags utagsClone = new UninterpretedTags();
            for (Map.Entry message : utags.entries()) {
                utagsClone.put(new Integer((Integer)message.getKey()), ((byte[])message.getValue()).clone());
            }
            return utagsClone;
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            return new UninterpretedTags();
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static int[] freezeArray(int[] arg, int size) {
        if (size == 0) {
            return FROZEN_INT_ARRAY;
        }
        if (ProtocolSupport.isArrayTooBig(arg.length, size)) {
            return Arrays.copyOf(arg, size);
        }
        return arg;
    }

    public static long[] freezeArray(long[] arg, int size) {
        if (size == 0) {
            return FROZEN_LONG_ARRAY;
        }
        if (ProtocolSupport.isArrayTooBig(arg.length, size)) {
            return Arrays.copyOf(arg, size);
        }
        return arg;
    }

    public static float[] freezeArray(float[] arg, int size) {
        if (size == 0) {
            return FROZEN_FLOAT_ARRAY;
        }
        if (ProtocolSupport.isArrayTooBig(arg.length, size)) {
            return Arrays.copyOf(arg, size);
        }
        return arg;
    }

    public static double[] freezeArray(double[] arg, int size) {
        if (size == 0) {
            return FROZEN_DOUBLE_ARRAY;
        }
        if (ProtocolSupport.isArrayTooBig(arg.length, size)) {
            return Arrays.copyOf(arg, size);
        }
        return arg;
    }

    public static boolean[] freezeArray(boolean[] arg, int size) {
        if (size == 0) {
            return FROZEN_BOOLEAN_ARRAY;
        }
        if (ProtocolSupport.isArrayTooBig(arg.length, size)) {
            return Arrays.copyOf(arg, size);
        }
        return arg;
    }

    public static <T extends ProtocolMessage<T>> List<T> freezeMessages(List<T> list) {
        if (list.size() == 0) {
            return ImmutableList.of();
        }
        for (ProtocolMessage item : list) {
            item.freeze();
        }
        return list;
    }

    public static List<byte[]> freezeStrings(List<byte[]> list) {
        if (list.size() == 0) {
            return ImmutableList.of();
        }
        return list;
    }

    public static byte[] freezeString(byte[] arg) {
        if (arg.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        return arg;
    }

    private static boolean isArrayTooBig(int capacity, int size) {
        return capacity - size >= 10 && size * 4 <= capacity * 3;
    }

    public static <T extends ProtocolMessage<T>> List<T> unfreezeMessages(List<T> list) {
        if (list instanceof ImmutableList) {
            list = new ArrayList<T>(list);
        }
        for (ProtocolMessage item : list) {
            item.unfreeze();
        }
        return list;
    }

    public static List<byte[]> unfreezeStrings(List<byte[]> list) {
        if (list instanceof ImmutableList) {
            list = new ArrayList<byte[]>(4);
        }
        return list;
    }

    public static <T extends ProtocolMessage<T>> boolean isFrozenMessages(List<T> list) {
        if (list instanceof ImmutableList) {
            return true;
        }
        for (ProtocolMessage message : list) {
            if (!message.isFrozen()) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean isFrozenStrings(List<T> list) {
        return list instanceof ImmutableList;
    }

    private ProtocolSupport() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ByteArrayToUnicodeFunction
    implements Function<byte[], String> {
        static final ByteArrayToUnicodeFunction defaultFunction = new ByteArrayToUnicodeFunction(Charset.forName("UTF-8"));
        private final Charset cs;

        static ByteArrayToUnicodeFunction getInstance() {
            return defaultFunction;
        }

        static ByteArrayToUnicodeFunction getInstance(Charset cs) {
            return new ByteArrayToUnicodeFunction(cs);
        }

        private ByteArrayToUnicodeFunction(Charset cs) {
            this.cs = cs;
        }

        @Override
        public String apply(byte[] object) {
            return Protocol.toString(object, this.cs);
        }

        List<String> asList(List<byte[]> data) {
            return Collections.unmodifiableList(Lists.transform(data, this));
        }
    }
}

