/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Supplier;
import com.google.appengine.repackaged.com.google.common.collect.AbstractMultiset;
import com.google.appengine.repackaged.com.google.common.collect.Collections2;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Iterators;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.Multimap;
import com.google.appengine.repackaged.com.google.common.collect.Multiset;
import com.google.appengine.repackaged.com.google.common.collect.Multisets;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.common.annotations.GoogleInternal;
import com.google.common.base.Nullable;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GoogleInternal
public class ConcreteMultimap<K, V, C extends Collection<V>>
implements Multimap<K, V>,
Serializable {
    private final Map<K, C> map;
    private final Supplier<? extends C> factory;
    private transient Set<K> keySet;
    private transient Multiset<K> keys;
    private transient Collection<V> valuesCollection;
    private transient Collection<Map.Entry<K, V>> entries;
    private transient Map<K, Collection<V>> asMap;
    private static final long serialVersionUID = 0L;

    public static <K, V, C extends Collection<V>> ConcreteMultimap<K, V, C> create(Map<K, C> map, Supplier<? extends C> factory) {
        Preconditions.checkArgument(map.isEmpty());
        return new ConcreteMultimap<K, V, C>(map, Preconditions.checkNotNull(factory));
    }

    private ConcreteMultimap(Map<K, C> map, Supplier<? extends C> factory) {
        this.map = map;
        this.factory = factory;
    }

    @Override
    public int size() {
        int size = 0;
        for (Collection collection : this.map.values()) {
            size += collection.size();
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        for (Collection collection : this.map.values()) {
            if (collection.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        Collection collection = (Collection)this.map.get(key);
        return collection != null && !collection.isEmpty();
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        for (Collection collection : this.map.values()) {
            if (!collection.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsEntry(@Nullable Object key, @Nullable Object value) {
        Collection collection = (Collection)this.map.get(key);
        return collection != null && collection.contains(value);
    }

    @Override
    public boolean put(K key, V value) {
        C collection = this.get(key);
        return collection.add(value);
    }

    @Override
    public boolean remove(@Nullable Object key, @Nullable Object value) {
        Collection collection = (Collection)this.map.get(key);
        return collection != null && collection.remove(value);
    }

    @Override
    public boolean putAll(K key, Iterable<? extends V> values) {
        C collection = this.get(key);
        return Iterables.addAll(collection, values);
    }

    @Override
    public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
        boolean changed = false;
        for (Map.Entry<K, V> entry : multimap.entries()) {
            changed |= this.put(entry.getKey(), entry.getValue());
        }
        return changed;
    }

    public C replaceValues(K key, Iterable<? extends V> values) {
        C collection = this.get(key);
        Collection oldValues = (Collection)this.factory.get();
        oldValues.addAll(collection);
        collection.clear();
        Iterables.addAll(collection, values);
        return (C)oldValues;
    }

    public C removeAll(Object key) {
        Collection collection = (Collection)this.map.get(key);
        Collection output = (Collection)this.factory.get();
        if (collection != null) {
            output.addAll(collection);
            collection.clear();
        }
        return (C)output;
    }

    @Override
    public void clear() {
        for (Collection collection : this.map.values()) {
            collection.clear();
        }
    }

    public C get(K key) {
        Collection collection = (Collection)this.map.get(key);
        if (collection == null) {
            collection = (Collection)this.factory.get();
            this.map.put(key, collection);
        }
        return (C)collection;
    }

    @Override
    public Set<K> keySet() {
        KeySet result = this.keySet;
        return result == null ? (this.keySet = new KeySet()) : result;
    }

    @Override
    public Multiset<K> keys() {
        Keys result = this.keys;
        return result == null ? (this.keys = new Keys()) : result;
    }

    private int removeValuesForKey(Object key) {
        Collection collection;
        try {
            collection = (Collection)this.map.get(key);
        }
        catch (NullPointerException e) {
            return 0;
        }
        catch (ClassCastException e) {
            return 0;
        }
        int count = 0;
        if (collection != null) {
            count = collection.size();
            collection.clear();
        }
        return count;
    }

    @Override
    public Collection<V> values() {
        Values result = this.valuesCollection;
        return result == null ? (this.valuesCollection = new Values()) : result;
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        Collection<Map.Entry<K, V>> result = this.entries;
        return this.entries == null ? (this.entries = this.createEntries()) : result;
    }

    private Collection<Map.Entry<K, V>> createEntries() {
        return this.factory.get() instanceof Set ? new EntrySet() : new Entries();
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        AsMap result = this.asMap;
        return result == null ? (this.asMap = new AsMap()) : result;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Multimap) {
            Multimap that = (Multimap)object;
            return ((Object)this.asMap()).equals(that.asMap());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.asMap()).hashCode();
    }

    public String toString() {
        return this.asMap().toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsMapIterator
    implements Iterator<Map.Entry<K, Collection<V>>> {
        final Iterator<Map.Entry<K, C>> entryIterator;
        Map.Entry<K, C> nextEntry;
        Map.Entry<K, C> lastEntry;

        private AsMapIterator() {
            this.entryIterator = ConcreteMultimap.this.map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            while (this.nextEntry == null || ((Collection)this.nextEntry.getValue()).isEmpty()) {
                if (!this.entryIterator.hasNext()) {
                    return false;
                }
                this.nextEntry = this.entryIterator.next();
            }
            return true;
        }

        @Override
        public Map.Entry<K, Collection<V>> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastEntry = this.nextEntry;
            this.nextEntry = null;
            return Maps.immutableEntry(this.lastEntry.getKey(), (Collection)this.lastEntry.getValue());
        }

        @Override
        public void remove() {
            Preconditions.checkState(this.lastEntry != null);
            ((Collection)this.lastEntry.getValue()).clear();
            this.lastEntry = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsMapEntries
    extends AbstractSet<Map.Entry<K, Collection<V>>> {
        private AsMapEntries() {
        }

        @Override
        public Iterator<Map.Entry<K, Collection<V>>> iterator() {
            return new AsMapIterator();
        }

        @Override
        public int size() {
            return ConcreteMultimap.this.keySet().size();
        }

        @Override
        public void clear() {
            ConcreteMultimap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            if (entry.getValue() instanceof Collection) {
                Collection collection = (Collection)entry.getValue();
                return !collection.isEmpty() && Objects.equal(ConcreteMultimap.this.map.get(entry.getKey()), collection);
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return this.contains(entry) && ConcreteMultimap.this.removeValuesForKey(entry.getKey()) > 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsMap
    extends AbstractMap<K, Collection<V>> {
        transient Set<Map.Entry<K, Collection<V>>> entrySet;

        private AsMap() {
        }

        @Override
        public Set<Map.Entry<K, Collection<V>>> entrySet() {
            AsMapEntries result = this.entrySet;
            return this.entrySet == null ? (this.entrySet = new AsMapEntries()) : result;
        }

        @Override
        public void clear() {
            ConcreteMultimap.this.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return ConcreteMultimap.this.containsKey(key);
        }

        @Override
        public C get(Object key) {
            Collection collection = (Collection)ConcreteMultimap.this.map.get(key);
            return collection == null || collection.isEmpty() ? null : collection;
        }

        @Override
        public Set<K> keySet() {
            return ConcreteMultimap.this.keySet();
        }

        @Override
        public C remove(Object key) {
            Object collection = ConcreteMultimap.this.removeAll(key);
            return collection.isEmpty() ? null : (Object)collection;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends Entries
    implements Set<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public boolean equals(@Nullable Object other) {
            return Collections2.setEquals(this, other);
        }

        @Override
        public int hashCode() {
            return Sets.hashCodeImpl(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        final Iterator<Map.Entry<K, C>> keyIterator;
        Map.Entry<K, C> nextEntry;
        Iterator<V> nextValueIterator = Iterators.emptyIterator();
        Iterator<V> removeIterator;

        EntryIterator() {
            this.keyIterator = ConcreteMultimap.this.map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            while (!this.nextValueIterator.hasNext()) {
                if (!this.keyIterator.hasNext()) {
                    return false;
                }
                this.nextEntry = this.keyIterator.next();
                this.nextValueIterator = ((Collection)this.nextEntry.getValue()).iterator();
            }
            return true;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.removeIterator = this.nextValueIterator;
            return Maps.immutableEntry(this.nextEntry.getKey(), this.nextValueIterator.next());
        }

        @Override
        public void remove() {
            Preconditions.checkState(this.removeIterator != null);
            this.removeIterator.remove();
            this.removeIterator = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entries
    extends AbstractCollection<Map.Entry<K, V>> {
        private Entries() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return ConcreteMultimap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return ConcreteMultimap.this.containsEntry(entry.getKey(), entry.getValue());
        }

        @Override
        public void clear() {
            ConcreteMultimap.this.clear();
        }

        @Override
        public boolean isEmpty() {
            return ConcreteMultimap.this.isEmpty();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return ConcreteMultimap.this.remove(entry.getKey(), entry.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator
    implements Iterator<V> {
        final Iterator<Map.Entry<K, V>> entryIterator;

        private ValueIterator() {
            this.entryIterator = new EntryIterator();
        }

        @Override
        public boolean hasNext() {
            return this.entryIterator.hasNext();
        }

        @Override
        public V next() {
            return this.entryIterator.next().getValue();
        }

        @Override
        public void remove() {
            this.entryIterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return ConcreteMultimap.this.size();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            Preconditions.checkNotNull(c);
            boolean changed = false;
            for (Collection collection : ConcreteMultimap.this.map.values()) {
                changed |= collection.removeAll(c);
            }
            return changed;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            Preconditions.checkNotNull(c);
            boolean changed = false;
            for (Collection collection : ConcreteMultimap.this.map.values()) {
                changed |= collection.retainAll(c);
            }
            return changed;
        }

        @Override
        public void clear() {
            ConcreteMultimap.this.clear();
        }

        @Override
        public boolean contains(Object value) {
            return ConcreteMultimap.this.containsValue(value);
        }

        @Override
        public boolean isEmpty() {
            return ConcreteMultimap.this.isEmpty();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultisetKeyIterator
    implements Iterator<K> {
        final Iterator<Map.Entry<K, V>> entryIterator;

        private MultisetKeyIterator() {
            this.entryIterator = ConcreteMultimap.this.entries().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.entryIterator.hasNext();
        }

        @Override
        public K next() {
            return this.entryIterator.next().getKey();
        }

        @Override
        public void remove() {
            this.entryIterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultisetEntry
    extends Multisets.AbstractEntry<K> {
        final Map.Entry<K, Collection<V>> entry;

        public MultisetEntry(Map.Entry<K, Collection<V>> entry) {
            this.entry = entry;
        }

        @Override
        public K getElement() {
            return this.entry.getKey();
        }

        @Override
        public int getCount() {
            return this.entry.getValue().size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultisetEntryIterator
    implements Iterator<Multiset.Entry<K>> {
        final Iterator<Map.Entry<K, Collection<V>>> asMapIterator;

        private MultisetEntryIterator() {
            this.asMapIterator = ConcreteMultimap.this.asMap().entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.asMapIterator.hasNext();
        }

        @Override
        public Multiset.Entry<K> next() {
            return new MultisetEntry(this.asMapIterator.next());
        }

        @Override
        public void remove() {
            this.asMapIterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Keys
    extends AbstractMultiset<K> {
        transient Set<Multiset.Entry<K>> entrySet;

        private Keys() {
        }

        @Override
        public int remove(Object key, int occurrences) {
            Collection collection;
            if (occurrences == 0) {
                return this.count(key);
            }
            Preconditions.checkArgument(occurrences > 0);
            try {
                collection = (Collection)ConcreteMultimap.this.map.get(key);
            }
            catch (NullPointerException e) {
                return 0;
            }
            catch (ClassCastException e) {
                return 0;
            }
            if (collection == null) {
                return 0;
            }
            int count = collection.size();
            if (occurrences >= count) {
                collection.clear();
                return count;
            }
            Iterator iterator = collection.iterator();
            for (int i = 0; i < occurrences; ++i) {
                iterator.next();
                iterator.remove();
            }
            return count;
        }

        @Override
        public Set<K> elementSet() {
            return ConcreteMultimap.this.keySet();
        }

        @Override
        public Set<Multiset.Entry<K>> entrySet() {
            EntrySet result = this.entrySet;
            return result == null ? (this.entrySet = new EntrySet()) : result;
        }

        @Override
        public Iterator<K> iterator() {
            return new MultisetKeyIterator();
        }

        @Override
        public int count(Object key) {
            try {
                Collection collection = (Collection)ConcreteMultimap.this.map.get(key);
                return collection == null ? 0 : collection.size();
            }
            catch (NullPointerException e) {
                return 0;
            }
            catch (ClassCastException e) {
                return 0;
            }
        }

        @Override
        public int size() {
            return ConcreteMultimap.this.size();
        }

        @Override
        public void clear() {
            ConcreteMultimap.this.clear();
        }

        @Override
        public boolean isEmpty() {
            return ConcreteMultimap.this.isEmpty();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class EntrySet
        extends AbstractSet<Multiset.Entry<K>> {
            private EntrySet() {
            }

            @Override
            public Iterator<Multiset.Entry<K>> iterator() {
                return new MultisetEntryIterator();
            }

            @Override
            public int size() {
                return ConcreteMultimap.this.keySet().size();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Multiset.Entry)) {
                    return false;
                }
                Multiset.Entry entry = (Multiset.Entry)o;
                if (entry.getCount() <= 0) {
                    return false;
                }
                Collection collection = (Collection)ConcreteMultimap.this.map.get(entry.getElement());
                return collection != null && collection.size() == entry.getCount();
            }

            @Override
            public void clear() {
                ConcreteMultimap.this.clear();
            }

            @Override
            public boolean isEmpty() {
                return ConcreteMultimap.this.isEmpty();
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Multiset.Entry)) {
                    return false;
                }
                Multiset.Entry entry = (Multiset.Entry)o;
                if (entry.getCount() <= 0) {
                    return false;
                }
                Collection collection = (Collection)ConcreteMultimap.this.map.get(entry.getElement());
                if (collection != null && collection.size() == entry.getCount()) {
                    collection.clear();
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public int size() {
            int size = 0;
            for (Collection collection : ConcreteMultimap.this.map.values()) {
                if (collection.isEmpty()) continue;
                ++size;
            }
            return size;
        }

        @Override
        public Iterator<K> iterator() {
            final Iterator asMapIterator = ConcreteMultimap.this.asMap().entrySet().iterator();
            return new Iterator<K>(){

                @Override
                public boolean hasNext() {
                    return asMapIterator.hasNext();
                }

                @Override
                public K next() {
                    return ((Map.Entry)asMapIterator.next()).getKey();
                }

                @Override
                public void remove() {
                    asMapIterator.remove();
                }
            };
        }

        @Override
        public void clear() {
            ConcreteMultimap.this.clear();
        }

        @Override
        public boolean contains(Object key) {
            return ConcreteMultimap.this.containsKey(key);
        }

        @Override
        public boolean isEmpty() {
            return ConcreteMultimap.this.isEmpty();
        }

        @Override
        public boolean remove(Object key) {
            Collection collection = (Collection)ConcreteMultimap.this.map.get(key);
            if (collection != null && !collection.isEmpty()) {
                collection.clear();
                return true;
            }
            return false;
        }
    }
}

