/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.memcache;

import java.util.Date;

public final class Expiration {
    private int seconds;

    public static Expiration onDate(Date expirationTime) {
        return new Expiration(expirationTime.getTime());
    }

    public static Expiration byDeltaMillis(int milliDelay) {
        return new Expiration(System.currentTimeMillis() + (long)milliDelay);
    }

    public int hashCode() {
        return Integer.valueOf(this.seconds).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Expiration) {
            return ((Expiration)obj).getSecondsValue() == this.seconds;
        }
        return false;
    }

    public static Expiration byDeltaSeconds(int secondsDelay) {
        return Expiration.byDeltaMillis(secondsDelay * 1000);
    }

    private Expiration(long millis) {
        this.seconds = (int)(millis / 1000L);
    }

    public int getSecondsValue() {
        return this.seconds;
    }
}

