/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AsyncDatastoreService;
import com.google.appengine.api.datastore.BaseDatastoreService;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.EntityTranslator;
import com.google.appengine.api.datastore.FutureHelper;
import com.google.appengine.api.datastore.ImplicitTransactionManagementPolicy;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyTranslator;
import com.google.appengine.api.datastore.ReadPolicy;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.appengine.api.datastore.TransactionStack;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.common.base.Pair;
import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AsyncDatastoreServiceImpl
extends BaseDatastoreService
implements AsyncDatastoreService {
    public AsyncDatastoreServiceImpl(DatastoreServiceConfig datastoreServiceConfig, TransactionStack defaultTxnProvider) {
        super(AsyncDatastoreServiceImpl.validateDatastoreServiceConfig(datastoreServiceConfig), defaultTxnProvider);
    }

    private static DatastoreServiceConfig validateDatastoreServiceConfig(DatastoreServiceConfig datastoreServiceConfig) {
        if (datastoreServiceConfig.getImplicitTransactionManagementPolicy() == ImplicitTransactionManagementPolicy.AUTO) {
            throw new IllegalArgumentException("The async datastore service does not support an implicit transaction management policy of AUTO");
        }
        return datastoreServiceConfig;
    }

    @Override
    public Future<Entity> get(Key key) {
        BaseDatastoreService.GetOrCreateTransactionResult result = this.getOrCreateTransaction();
        return this.get(result.getTransaction(), key);
    }

    @Override
    public Future<Entity> get(Transaction txn, final Key key) {
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        Future<Map<Key, Entity>> entities = this.get(txn, Arrays.asList(key));
        return new FutureWrapper<Map<Key, Entity>, Entity>(entities){

            @Override
            protected Entity wrap(Map<Key, Entity> entities) throws Exception {
                Entity entity = entities.get(key);
                if (entity == null) {
                    throw new EntityNotFoundException(key);
                }
                return entity;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    @Override
    public Future<Map<Key, Entity>> get(Iterable<Key> keys) {
        BaseDatastoreService.GetOrCreateTransactionResult result = this.getOrCreateTransaction();
        return this.get(result.getTransaction(), keys);
    }

    @Override
    public Future<Map<Key, Entity>> get(Transaction txn, final Iterable<Key> keys) {
        if (keys == null) {
            throw new NullPointerException("keys cannot be null");
        }
        DatastorePb.GetRequest baseReq = new DatastorePb.GetRequest();
        if (txn != null) {
            TransactionImpl.ensureTxnActive(txn);
            baseReq.setTransaction(AsyncDatastoreServiceImpl.localTxnToRemoteTxn(txn));
        }
        if (this.datastoreServiceConfig.getReadPolicy().getConsistency() == ReadPolicy.Consistency.EVENTUAL) {
            baseReq.setFailoverMs(-1L);
        }
        int baseEncodedReqSize = baseReq.encodingSize();
        ArrayList<Future<DatastorePb.GetResponse>> futures = new ArrayList<Future<DatastorePb.GetResponse>>();
        DatastorePb.GetRequest req = (DatastorePb.GetRequest)baseReq.clone();
        int encodedReqSize = baseEncodedReqSize;
        for (Key key : keys) {
            if (!key.isComplete()) {
                throw new IllegalArgumentException(key + " is incomplete.");
            }
            OnestoreEntity.Reference ref = KeyTranslator.convertToPb(key);
            int encodedKeySize = Protocol.stringSize(ref.encodingSize()) + 1;
            if (this.datastoreServiceConfig.exceedsReadLimits(req.keySize() + 1, encodedReqSize + encodedKeySize)) {
                futures.add(DatastoreApiHelper.makeAsyncCall(this.apiConfig, "Get", req, new DatastorePb.GetResponse()));
                encodedReqSize = baseEncodedReqSize;
                req = (DatastorePb.GetRequest)baseReq.clone();
            }
            encodedReqSize += encodedKeySize;
            req.addKey(ref);
        }
        if (req.keySize() > 0) {
            futures.add(DatastoreApiHelper.makeAsyncCall(this.apiConfig, "Get", req, new DatastorePb.GetResponse()));
        }
        return this.registerInTransaction(txn, new IteratingAggregateFuture<DatastorePb.GetResponse, Key, Map<Key, Entity>>(futures){

            @Override
            protected Map<Key, Entity> initResult() {
                return new HashMap<Key, Entity>();
            }

            @Override
            protected Iterator<Key> initIterator() {
                return keys.iterator();
            }

            @Override
            protected Map<Key, Entity> aggregate(DatastorePb.GetResponse response, Iterator<Key> keyIterator, Map<Key, Entity> results) {
                for (DatastorePb.GetResponse.Entity responseEntity : response.entitys()) {
                    Key key = keyIterator.next();
                    if (!responseEntity.hasEntity()) continue;
                    results.put(key, EntityTranslator.createFromPb(responseEntity.getEntity()));
                }
                return results;
            }
        });
    }

    @Override
    public Future<Key> put(Entity entity) {
        BaseDatastoreService.GetOrCreateTransactionResult result = this.getOrCreateTransaction();
        return this.put(result.getTransaction(), entity);
    }

    @Override
    public Future<Key> put(Transaction txn, Entity entity) {
        return new FutureWrapper<List<Key>, Key>(this.put(txn, Arrays.asList(entity))){

            @Override
            protected Key wrap(List<Key> keys) throws Exception {
                return keys.get(0);
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    @Override
    public Future<List<Key>> put(Iterable<Entity> entities) {
        BaseDatastoreService.GetOrCreateTransactionResult result = this.getOrCreateTransaction();
        return this.put(result.getTransaction(), entities);
    }

    @Override
    public Future<List<Key>> put(Transaction txn, final Iterable<Entity> entities) {
        DatastorePb.PutRequest baseReq = new DatastorePb.PutRequest();
        if (txn != null) {
            TransactionImpl.ensureTxnActive(txn);
            baseReq.setTransaction(AsyncDatastoreServiceImpl.localTxnToRemoteTxn(txn));
        }
        int baseEncodedReqSize = baseReq.encodingSize();
        ArrayList<Future<DatastorePb.PutResponse>> futures = new ArrayList<Future<DatastorePb.PutResponse>>();
        int encodedReqSize = baseEncodedReqSize;
        DatastorePb.PutRequest req = (DatastorePb.PutRequest)baseReq.clone();
        for (Entity entity : entities) {
            OnestoreEntity.EntityProto proto = EntityTranslator.convertToPb(entity);
            int encodedEntitySize = Protocol.stringSize(proto.encodingSize()) + 1;
            if (this.datastoreServiceConfig.exceedsWriteLimits(req.entitySize() + 1, encodedReqSize + encodedEntitySize)) {
                futures.add(DatastoreApiHelper.makeAsyncCall(this.apiConfig, "Put", req, new DatastorePb.PutResponse()));
                encodedReqSize = baseEncodedReqSize;
                req = (DatastorePb.PutRequest)baseReq.clone();
            }
            encodedReqSize += encodedEntitySize;
            req.addEntity(proto);
        }
        if (req.entitySize() > 0) {
            futures.add(DatastoreApiHelper.makeAsyncCall(this.apiConfig, "Put", req, new DatastorePb.PutResponse()));
        }
        return this.registerInTransaction(txn, new IteratingAggregateFuture<DatastorePb.PutResponse, Entity, List<Key>>(futures){

            @Override
            protected List<Key> initResult() {
                return new ArrayList<Key>();
            }

            @Override
            protected Iterator<Entity> initIterator() {
                return entities.iterator();
            }

            @Override
            protected List<Key> aggregate(DatastorePb.PutResponse intermediateResult, Iterator<Entity> entitiesIterator, List<Key> keysInOrder) {
                for (OnestoreEntity.Reference reference : intermediateResult.keys()) {
                    Entity entity = entitiesIterator.next();
                    KeyTranslator.updateKey(reference, entity.getKey());
                    keysInOrder.add(entity.getKey());
                }
                return keysInOrder;
            }
        });
    }

    @Override
    public Future<Void> delete(Key ... keys) {
        BaseDatastoreService.GetOrCreateTransactionResult result = this.getOrCreateTransaction();
        return this.delete(result.getTransaction(), keys);
    }

    @Override
    public Future<Void> delete(Transaction txn, Key ... keys) {
        return this.delete(txn, Arrays.asList(keys));
    }

    @Override
    public Future<Void> delete(Iterable<Key> keys) {
        BaseDatastoreService.GetOrCreateTransactionResult result = this.getOrCreateTransaction();
        return this.delete(result.getTransaction(), keys);
    }

    @Override
    public Future<Void> delete(Transaction txn, Iterable<Key> keys) {
        DatastorePb.DeleteRequest baseReq = new DatastorePb.DeleteRequest();
        if (txn != null) {
            TransactionImpl.ensureTxnActive(txn);
            baseReq.setTransaction(AsyncDatastoreServiceImpl.localTxnToRemoteTxn(txn));
        }
        int baseEncodedReqSize = baseReq.encodingSize();
        ArrayList<Future<DatastorePb.DeleteResponse>> futures = new ArrayList<Future<DatastorePb.DeleteResponse>>();
        int encodedReqSize = baseEncodedReqSize;
        DatastorePb.DeleteRequest req = (DatastorePb.DeleteRequest)baseReq.clone();
        for (Key key : keys) {
            if (!key.isComplete()) {
                throw new IllegalArgumentException(key + " is incomplete.");
            }
            OnestoreEntity.Reference ref = KeyTranslator.convertToPb(key);
            int encodedKeySize = Protocol.stringSize(ref.encodingSize()) + 1;
            if (this.datastoreServiceConfig.exceedsWriteLimits(req.keySize() + 1, encodedReqSize + encodedKeySize)) {
                futures.add(DatastoreApiHelper.makeAsyncCall(this.apiConfig, "Delete", req, new DatastorePb.DeleteResponse()));
                encodedReqSize = baseEncodedReqSize;
                req = (DatastorePb.DeleteRequest)baseReq.clone();
            }
            encodedReqSize += encodedKeySize;
            req.addKey(ref);
        }
        if (req.keySize() > 0) {
            futures.add(DatastoreApiHelper.makeAsyncCall(this.apiConfig, "Delete", req, new DatastorePb.DeleteResponse()));
        }
        return this.registerInTransaction(txn, new FutureHelper.CumulativeAggregateFuture<DatastorePb.DeleteResponse, Void, Void>(futures){

            @Override
            protected Void aggregate(DatastorePb.DeleteResponse intermediateResult, Void result) {
                return null;
            }

            @Override
            protected Void finalizeResult(Void result) {
                return null;
            }

            @Override
            protected Void initIntermediateResult() {
                return null;
            }
        });
    }

    public Collection<Transaction> getActiveTransactions() {
        return this.defaultTxnProvider.getAll();
    }

    private <T> Future<T> registerInTransaction(Transaction txn, Future<T> future) {
        if (txn != null) {
            this.defaultTxnProvider.addFuture(txn, future);
            return new FutureHelper.TxnAwareFuture<T>(future, txn, this.defaultTxnProvider);
        }
        return future;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class IteratingAggregateFuture<K, I, V>
    extends FutureHelper.CumulativeAggregateFuture<K, Pair<Iterator<I>, V>, V> {
        public IteratingAggregateFuture(Iterable<Future<K>> futures) {
            super(futures);
        }

        protected abstract V aggregate(K var1, Iterator<I> var2, V var3);

        protected abstract Iterator<I> initIterator();

        protected abstract V initResult();

        @Override
        protected final Pair<Iterator<I>, V> aggregate(K intermediateResult, Pair<Iterator<I>, V> result) {
            return Pair.of(result.first, this.aggregate(intermediateResult, (Iterator)result.first, result.second));
        }

        @Override
        protected V finalizeResult(Pair<Iterator<I>, V> result) {
            return (V)result.second;
        }

        @Override
        protected final Pair<Iterator<I>, V> initIntermediateResult() {
            return Pair.of(this.initIterator(), this.initResult());
        }
    }
}

