/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DataTypeTranslator;
import com.google.appengine.api.datastore.FilterMatcher;
import com.google.appengine.api.datastore.ValidatedQuery;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class EntityProtoComparators {
    public static final Comparator<Comparable<Object>> MULTI_TYPE_COMPARATOR = new MultiTypeComparator();
    static final DatastorePb.Query.Order KEY_ASC_ORDER = new DatastorePb.Query.Order().setProperty("__key__").setDirection(DatastorePb.Query.Order.Direction.ASCENDING);

    private EntityProtoComparators() {
    }

    private static final class MultiTypeComparator
    implements Comparator<Comparable<Object>> {
        private MultiTypeComparator() {
        }

        @Override
        public int compare(Comparable<Object> o1, Comparable<Object> o2) {
            Integer comp2TypeRank;
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            Integer comp1TypeRank = DataTypeTranslator.getTypeRank(o1.getClass());
            if (comp1TypeRank.equals(comp2TypeRank = Integer.valueOf(DataTypeTranslator.getTypeRank(o2.getClass())))) {
                return o1.compareTo(o2);
            }
            return comp1TypeRank.compareTo(comp2TypeRank);
        }
    }

    public static final class EntityProtoComparator
    implements Comparator<OnestoreEntity.EntityProto> {
        final List<DatastorePb.Query.Order> orders;
        final Map<String, FilterMatcher> filters;

        public EntityProtoComparator(List<DatastorePb.Query.Order> orders) {
            this(orders, Collections.emptyList());
        }

        public EntityProtoComparator(List<DatastorePb.Query.Order> orders, List<DatastorePb.Query.Filter> filters) {
            this.orders = EntityProtoComparator.makeAdjustedOrders(orders, filters);
            this.filters = EntityProtoComparator.makeFilterMatchers(orders, filters);
        }

        private static List<DatastorePb.Query.Order> makeAdjustedOrders(List<DatastorePb.Query.Order> orders, List<DatastorePb.Query.Filter> filters) {
            ArrayList<DatastorePb.Query.Order> adjusted = new ArrayList<DatastorePb.Query.Order>(orders.size() + 1);
            for (DatastorePb.Query.Order order : orders) {
                adjusted.add(order);
                if (!order.getProperty().equals(KEY_ASC_ORDER.getProperty())) continue;
                return adjusted;
            }
            if (adjusted.isEmpty()) {
                for (DatastorePb.Query.Filter filter : filters) {
                    if (!ValidatedQuery.INEQUALITY_OPERATORS.contains(filter.getOpEnum())) continue;
                    adjusted.add(new DatastorePb.Query.Order().setProperty(filter.getProperty(0).getName()).setDirection(DatastorePb.Query.Order.Direction.ASCENDING));
                    break;
                }
            }
            adjusted.add(KEY_ASC_ORDER);
            return adjusted;
        }

        private static Map<String, FilterMatcher> makeFilterMatchers(List<DatastorePb.Query.Order> orders, List<DatastorePb.Query.Filter> filters) {
            HashMap<String, FilterMatcher> filterMatchers = new HashMap<String, FilterMatcher>();
            for (DatastorePb.Query.Filter filter : filters) {
                String name = filter.getProperty(0).getName();
                FilterMatcher filterMatcher = (FilterMatcher)filterMatchers.get(name);
                if (filterMatcher == null) {
                    filterMatcher = new FilterMatcher();
                    filterMatchers.put(name, filterMatcher);
                }
                filterMatcher.addFilter(filter);
            }
            for (DatastorePb.Query.Order order : orders) {
                if (!filterMatchers.containsKey(order.getProperty())) {
                    filterMatchers.put(order.getProperty(), FilterMatcher.MATCH_ALL);
                }
                if (!order.getProperty().equals(KEY_ASC_ORDER.getProperty())) continue;
                break;
            }
            return filterMatchers;
        }

        public List<DatastorePb.Query.Order> getAdjustedOrders() {
            return Collections.unmodifiableList(this.orders);
        }

        public boolean matches(OnestoreEntity.EntityProto proto) {
            for (String property : this.filters.keySet()) {
                List<Comparable<Object>> values = EntityProtoComparator.getComparablePropertyValues(proto, property);
                if (values != null && this.filters.get(property).matches(values)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int compare(OnestoreEntity.EntityProto protoA, OnestoreEntity.EntityProto protoB) {
            for (DatastorePb.Query.Order order : this.orders) {
                Comparable<Object> extremeB;
                Comparable<Object> extremeA;
                int result;
                String property = order.getProperty();
                List<Comparable<Object>> aValues = EntityProtoComparator.getComparablePropertyValues(protoA, property);
                List<Comparable<Object>> bValues = EntityProtoComparator.getComparablePropertyValues(protoB, property);
                if (aValues == null || bValues == null) {
                    throw new IllegalStateException("Trying to sort on a non-existent property.");
                }
                boolean findMin = order.getDirectionEnum() == DatastorePb.Query.Order.Direction.ASCENDING;
                FilterMatcher matcher = this.filters.get(property);
                if (matcher == null) {
                    matcher = FilterMatcher.MATCH_ALL;
                }
                if ((result = MULTI_TYPE_COMPARATOR.compare(extremeA = EntityProtoComparator.multiTypeExtreme(aValues, findMin, matcher), extremeB = EntityProtoComparator.multiTypeExtreme(bValues, findMin, matcher))) == 0) continue;
                if (order.getDirectionEnum() == DatastorePb.Query.Order.Direction.DESCENDING) {
                    result = -result;
                }
                return result;
            }
            return 0;
        }

        static List<Comparable<Object>> getComparablePropertyValues(OnestoreEntity.EntityProto entityProto, String propertyName) {
            Collection<OnestoreEntity.Property> entityProperties = DataTypeTranslator.findIndexedPropertiesOnPb(entityProto, propertyName);
            if (entityProperties.isEmpty()) {
                return null;
            }
            ArrayList<Comparable<Object>> values = new ArrayList<Comparable<Object>>(entityProperties.size());
            for (OnestoreEntity.Property prop : entityProperties) {
                values.add(DataTypeTranslator.getComparablePropertyValue(prop));
            }
            return values;
        }

        static Comparable<Object> multiTypeExtreme(Collection<Comparable<Object>> comparables, boolean findMin, FilterMatcher matcher) {
            boolean findMax = !findMin;
            Comparable<Object> extreme = FilterMatcher.NoValue.INSTANCE;
            for (Comparable<Object> value : comparables) {
                if (!matcher.considerValueForOrder(value)) continue;
                if (extreme == FilterMatcher.NoValue.INSTANCE) {
                    extreme = value;
                    continue;
                }
                if (findMin && MULTI_TYPE_COMPARATOR.compare(value, extreme) < 0) {
                    extreme = value;
                    continue;
                }
                if (!findMax || MULTI_TYPE_COMPARATOR.compare(value, extreme) <= 0) continue;
                extreme = value;
            }
            if (extreme == FilterMatcher.NoValue.INSTANCE) {
                throw new IllegalArgumentException("Entity contains no relevant values.");
            }
            return extreme;
        }
    }
}

