/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.ListDocumentsRequestChecker;

public final class ListRequest {
    private final String startId;
    private final boolean includeStart;
    private final int limit;
    private final boolean keysOnly;

    private ListRequest(Builder builder) {
        this.startId = builder.startId;
        this.includeStart = this.startId == null ? Boolean.FALSE : Util.defaultIfNull(builder.includeStart, Boolean.TRUE);
        this.limit = Util.defaultIfNull(builder.limit, 100);
        this.keysOnly = Util.defaultIfNull(builder.keysOnly, Boolean.FALSE);
    }

    public static final Builder newBuilder() {
        return new Builder();
    }

    public static final Builder newBuilder(ListRequest request) {
        return new Builder(request);
    }

    public String getStartId() {
        return this.startId;
    }

    public boolean isIncludeStart() {
        return this.includeStart;
    }

    public int getLimit() {
        return this.limit;
    }

    public Boolean isKeysOnly() {
        return this.keysOnly;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.includeStart ? 1 : 0);
        result = 31 * result + (this.keysOnly ? 1 : 0);
        result = 31 * result + this.limit;
        result = 31 * result + (this.startId == null ? 0 : this.startId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListRequest other = (ListRequest)obj;
        return this.includeStart == other.includeStart && this.keysOnly == other.keysOnly && this.limit == other.limit && Util.equalObjects(this.startId, other.startId);
    }

    public String toString() {
        return "ListRequest(includeStart=" + this.includeStart + ", startId=" + this.startId + ", limit=" + this.limit + ", keysOnly=" + this.keysOnly + ")";
    }

    public static final class Builder {
        private String startId;
        private Boolean includeStart;
        private Integer limit;
        private Boolean keysOnly;

        private Builder() {
            this.includeStart = true;
            this.keysOnly = false;
        }

        private Builder(ListRequest request) {
            this.startId = request.getStartId();
            this.includeStart = request.isIncludeStart();
            this.limit = request.getLimit();
            this.keysOnly = request.isKeysOnly();
        }

        public Builder setStartId(String startId) {
            this.startId = ListDocumentsRequestChecker.checkStartDocId(startId);
            return this;
        }

        public Builder setIncludeStart(boolean includeStart) {
            this.includeStart = includeStart;
            return this;
        }

        public Builder setLimit(Integer limit) {
            this.limit = ListDocumentsRequestChecker.checkLimit(limit);
            return this;
        }

        public Builder setKeysOnly(boolean keysOnly) {
            this.keysOnly = keysOnly;
            return this;
        }

        public ListRequest build() {
            return new ListRequest(this);
        }
    }
}

