/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.Strongly;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Charsets;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.annotation.Nullable;

@GoogleInternal
public final class Hash {
    private static final int SEED32 = 314159265;
    static final long SEED64 = 3141592653589793238L;
    private static final int CONSTANT32 = -1640531527;
    static final long CONSTANT64 = -2266404186210603134L;

    private Hash() {
    }

    @Deprecated
    @Strongly(contact="java-core-libraries-team", date="2012-05-01")
    public static int hash32(int value) {
        return Hash.mix32(value, -1640531527, 314159265);
    }

    @Deprecated
    @Strongly(contact="java-core-libraries-team", date="2012-05-01")
    public static int hash32(int value, int seed) {
        return Hash.mix32(value, -1640531527, seed);
    }

    @Deprecated
    @Strongly(contact="java-core-libraries-team", date="2012-05-01")
    public static int hash32(long value) {
        return (int)Hash.mix64(value, -2266404186210603134L, 3141592653589793238L);
    }

    @Deprecated
    @Strongly(contact="java-core-libraries-team", date="2012-05-01")
    public static int hash32(long value, long seed) {
        return (int)Hash.mix64(value, -2266404186210603134L, seed);
    }

    @Deprecated
    @Strongly(contact="java-core-libraries-team", date="2012-05-01")
    public static long hash64(long value) {
        return Hash.mix64(value, -2266404186210603134L, 3141592653589793238L);
    }

    @Deprecated
    @Strongly(contact="java-core-libraries-team", date="2012-05-01")
    public static long hash64(long value, long seed) {
        return Hash.mix64(value, -2266404186210603134L, seed);
    }

    @Deprecated
    @Strongly(contact="java-core-libraries-team", date="2012-05-01")
    public static int hash32(@Nullable String value, Charset charset) {
        return Hash.hash32(value, charset, 314159265);
    }

    @Deprecated
    @Strongly(contact="java-core-libraries-team", date="2012-05-01")
    public static int hash32(@Nullable String value) {
        return Hash.hash32(value, 314159265);
    }

    @Deprecated
    @Strongly(contact="java-core-libraries-team", date="2012-05-01")
    public static int hash32(@Nullable String value, Charset charset, int seed) {
        Preconditions.checkNotNull(charset);
        if (value == null) {
            return Hash.hash32(null, 0, 0, seed);
        }
        return Hash.hash32(value.getBytes(charset), seed);
    }

    @Deprecated
    @Strongly(contact="java-core-libraries-team", date="2012-05-01")
    public static int hash32(@Nullable String value, int seed) {
        if (value == null) {
            return Hash.hash32(null, 0, 0, seed);
        }
        return Hash.hash32(value.getBytes(), seed);
    }

    @Deprecated
    @Strongly(contact="java-core-libraries-team", date="2012-05-01")
    public static long hash64(@Nullable String value, Charset charset) {
        return Hash.hash64(value, charset, 3141592653589793238L);
    }

    @Deprecated
    @Strongly(contact="java-core-libraries-team", date="2012-05-01")
    public static long hash64(@Nullable String value) {
        return Hash.hash64(value, 3141592653589793238L);
    }

    @Deprecated
    @Strongly(contact="java-core-libraries-team", date="2012-05-01")
    public static long hash64(@Nullable String value, Charset charset, long seed) {
        Preconditions.checkNotNull(charset);
        if (value == null) {
            return Hash.hash64(null, 0, 0, seed);
        }
        return Hash.hash64(value.getBytes(charset), seed);
    }

    @Deprecated
    @Strongly(contact="java-core-libraries-team", date="2012-05-01")
    public static long hash64(@Nullable String value, long seed) {
        if (value == null) {
            return Hash.hash64(null, 0, 0, seed);
        }
        return Hash.hash64(value.getBytes(), seed);
    }

    @Deprecated
    @Strongly(contact="java-core-libraries-team", date="2012-05-01")
    public static long fingerprint(String value) {
        byte[] temp = value.getBytes(Charsets.UTF_8);
        return Hash.fingerprint(temp, 0, temp.length);
    }

    @Deprecated
    @Strongly(contact="java-core-libraries-team", date="2012-05-01")
    public static byte[] fprint96(String value) {
        return Hash.fprint96(value.getBytes(Charsets.UTF_8));
    }

    @Deprecated
    @Strongly(contact="java-core-libraries-team", date="2012-05-01")
    public static byte[] fprint96(byte[] value) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA-1 should be available in the JVM.");
        }
        md.update(value);
        byte[] hash = md.digest();
        return Arrays.copyOfRange(hash, 0, 12);
    }

    public static String fprint96AsString(String value) {
        return Hash.formatFprint96AsString(Hash.fprint96(value));
    }

    public static String fprint96AsKey(String value) {
        byte[] fp96 = Hash.fprint96(value.getBytes(Charsets.UTF_8));
        char[] chars = new char[12];
        for (int i = 0; i < 12; ++i) {
            chars[i] = (char)(fp96[i] & 0xFF);
        }
        return new String(chars);
    }

    @VisibleForTesting
    static byte[] keyToFprint96(String key) {
        byte[] fprint96 = new byte[12];
        for (int i = 0; i < 12; ++i) {
            fprint96[i] = (byte)(key.charAt(i) & 0xFF);
        }
        return fprint96;
    }

    public static int fprint96KeyModShardFromKey(String key, int numShards) {
        Preconditions.checkArgument(numShards > 0);
        IntBuffer ib = ByteBuffer.wrap(Hash.keyToFprint96(key)).asIntBuffer();
        BigInteger mod = BigInteger.valueOf(numShards);
        BigInteger group0 = BigInteger.valueOf((long)ib.get() & 0xFFFFFFFFL);
        BigInteger group1 = BigInteger.valueOf((long)ib.get() & 0xFFFFFFFFL);
        BigInteger group2 = BigInteger.valueOf((long)ib.get() & 0xFFFFFFFFL);
        group0 = group0.shiftLeft(32);
        BigInteger remainder = group0.or(group1).mod(mod);
        return remainder.shiftLeft(32).or(group2).mod(mod).intValue();
    }

    public static String formatFprint96AsString(byte[] value) {
        Preconditions.checkArgument(value.length == 12);
        IntBuffer ib = ByteBuffer.wrap(value).asIntBuffer();
        long group0 = (long)ib.get() & 0xFFFFFFFFL;
        long group1 = (long)ib.get() & 0xFFFFFFFFL;
        long group2 = (long)ib.get() & 0xFFFFFFFFL;
        return String.format("%08X_%08X_%08X", group0, group1, group2);
    }

    @Deprecated
    @Strongly(contact="java-core-libraries-team", date="2012-05-01")
    public static int hash32(byte[] value) {
        return Hash.hash32(value, 0, value == null ? 0 : value.length);
    }

    @Deprecated
    @Strongly(contact="java-core-libraries-team", date="2012-05-01")
    public static int hash32(@Nullable byte[] value, int seed) {
        return Hash.hash32(value, 0, value == null ? 0 : value.length, seed);
    }

    @Deprecated
    @Strongly(contact="java-core-libraries-team", date="2012-05-01")
    public static int hash32(byte[] value, int offset, int length) {
        return Hash.hash32(value, offset, length, 314159265);
    }

    private static int hash32(byte[] value, int offset, int length, int seed) {
        int a;
        int b = a = -1640531527;
        int c = seed;
        int keylen = length;
        while (keylen >= 12) {
            a += Hash.word32At(value, offset);
            a -= (b += Hash.word32At(value, offset + 4));
            a -= (c += Hash.word32At(value, offset + 8));
            b -= c;
            b -= (a ^= c >>> 13);
            c -= a;
            c -= (b ^= a << 8);
            a -= b;
            a -= (c ^= b >>> 13);
            b -= c;
            b -= (a ^= c >>> 12);
            c -= a;
            c -= (b ^= a << 16);
            a -= b;
            a -= (c ^= b >>> 5);
            b -= c;
            b -= (a ^= c >>> 3);
            c -= a;
            c -= (b ^= a << 10);
            c ^= b >>> 15;
            keylen -= 12;
            offset += 12;
        }
        c += length;
        switch (keylen) {
            case 11: {
                c += value[offset + 10] << 24;
            }
            case 10: {
                c += (value[offset + 9] & 0xFF) << 16;
            }
            case 9: {
                c += (value[offset + 8] & 0xFF) << 8;
            }
            case 8: {
                b += Hash.word32At(value, offset + 4);
                a += Hash.word32At(value, offset);
                break;
            }
            case 7: {
                b += (value[offset + 6] & 0xFF) << 16;
            }
            case 6: {
                b += (value[offset + 5] & 0xFF) << 8;
            }
            case 5: {
                b += value[offset + 4] & 0xFF;
            }
            case 4: {
                a += Hash.word32At(value, offset);
                break;
            }
            case 3: {
                a += (value[offset + 2] & 0xFF) << 16;
            }
            case 2: {
                a += (value[offset + 1] & 0xFF) << 8;
            }
            case 1: {
                a += value[offset + 0] & 0xFF;
            }
        }
        return Hash.mix32(a, b, c);
    }

    @Deprecated
    @Strongly(contact="java-core-libraries-team", date="2012-05-01")
    public static long hash64(@Nullable byte[] value) {
        return Hash.hash64(value, 0, value == null ? 0 : value.length);
    }

    static long hash64(@Nullable byte[] value, int offset, int length) {
        return Hash.hash64(value, offset, length, 3141592653589793238L);
    }

    static long hash64(@Nullable byte[] value, long seed) {
        return Hash.hash64(value, 0, value == null ? 0 : value.length, seed);
    }

    static long hash64(byte[] value, int offset, int length, long seed) {
        long a;
        long b = a = -2266404186210603134L;
        long c = seed;
        int keylen = length;
        while (keylen >= 24) {
            a += Hash.word64At(value, offset);
            a -= (b += Hash.word64At(value, offset + 8));
            a -= (c += Hash.word64At(value, offset + 16));
            b -= c;
            b -= (a ^= c >>> 43);
            c -= a;
            c -= (b ^= a << 9);
            a -= b;
            a -= (c ^= b >>> 8);
            b -= c;
            b -= (a ^= c >>> 38);
            c -= a;
            c -= (b ^= a << 23);
            a -= b;
            a -= (c ^= b >>> 5);
            b -= c;
            b -= (a ^= c >>> 35);
            c -= a;
            c -= (b ^= a << 49);
            a -= b;
            a -= (c ^= b >>> 11);
            b -= c;
            b -= (a ^= c >>> 12);
            c -= a;
            c -= (b ^= a << 18);
            c ^= b >>> 22;
            keylen -= 24;
            offset += 24;
        }
        c += (long)length;
        switch (keylen) {
            case 23: {
                c += (long)value[offset + 22] << 56;
            }
            case 22: {
                c += ((long)value[offset + 21] & 0xFFL) << 48;
            }
            case 21: {
                c += ((long)value[offset + 20] & 0xFFL) << 40;
            }
            case 20: {
                c += ((long)value[offset + 19] & 0xFFL) << 32;
            }
            case 19: {
                c += ((long)value[offset + 18] & 0xFFL) << 24;
            }
            case 18: {
                c += ((long)value[offset + 17] & 0xFFL) << 16;
            }
            case 17: {
                c += ((long)value[offset + 16] & 0xFFL) << 8;
            }
            case 16: {
                b += Hash.word64At(value, offset + 8);
                a += Hash.word64At(value, offset);
                break;
            }
            case 15: {
                b += ((long)value[offset + 14] & 0xFFL) << 48;
            }
            case 14: {
                b += ((long)value[offset + 13] & 0xFFL) << 40;
            }
            case 13: {
                b += ((long)value[offset + 12] & 0xFFL) << 32;
            }
            case 12: {
                b += ((long)value[offset + 11] & 0xFFL) << 24;
            }
            case 11: {
                b += ((long)value[offset + 10] & 0xFFL) << 16;
            }
            case 10: {
                b += ((long)value[offset + 9] & 0xFFL) << 8;
            }
            case 9: {
                b += (long)value[offset + 8] & 0xFFL;
            }
            case 8: {
                a += Hash.word64At(value, offset);
                break;
            }
            case 7: {
                a += ((long)value[offset + 6] & 0xFFL) << 48;
            }
            case 6: {
                a += ((long)value[offset + 5] & 0xFFL) << 40;
            }
            case 5: {
                a += ((long)value[offset + 4] & 0xFFL) << 32;
            }
            case 4: {
                a += ((long)value[offset + 3] & 0xFFL) << 24;
            }
            case 3: {
                a += ((long)value[offset + 2] & 0xFFL) << 16;
            }
            case 2: {
                a += ((long)value[offset + 1] & 0xFFL) << 8;
            }
            case 1: {
                a += (long)value[offset + 0] & 0xFFL;
            }
        }
        return Hash.mix64(a, b, c);
    }

    private static int word32At(byte[] bytes, int offset) {
        return bytes[offset + 0] + (bytes[offset + 1] << 8) + (bytes[offset + 2] << 16) + (bytes[offset + 3] << 24);
    }

    private static long word64At(byte[] bytes, int offset) {
        return ((long)bytes[offset + 0] & 0xFFL) + (((long)bytes[offset + 1] & 0xFFL) << 8) + (((long)bytes[offset + 2] & 0xFFL) << 16) + (((long)bytes[offset + 3] & 0xFFL) << 24) + (((long)bytes[offset + 4] & 0xFFL) << 32) + (((long)bytes[offset + 5] & 0xFFL) << 40) + (((long)bytes[offset + 6] & 0xFFL) << 48) + (((long)bytes[offset + 7] & 0xFFL) << 56);
    }

    @Deprecated
    @Strongly(contact="java-core-libraries-team", date="2012-05-01")
    public static long fingerprint(byte[] value) {
        return Hash.fingerprint(value, 0, value == null ? 0 : value.length);
    }

    @Deprecated
    @Strongly(contact="java-core-libraries-team", date="2012-05-01")
    public static long fingerprint(byte[] value, int offset, int length) {
        int hi = Hash.hash32(value, offset, length, 0);
        int lo = Hash.hash32(value, offset, length, 102072);
        if (hi == 0 && (lo == 0 || lo == 1)) {
            hi ^= 0x130F9BEF;
            lo ^= 0x94A0A928;
        }
        return (long)hi << 32 | (long)lo & 0xFFFFFFFFL;
    }

    private static int mix32(int a, int b, int c) {
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >>> 13);
        c -= a;
        c -= (b ^= a << 8);
        a -= b;
        a -= (c ^= b >>> 13);
        b -= c;
        b -= (a ^= c >>> 12);
        c -= a;
        c -= (b ^= a << 16);
        a -= b;
        a -= (c ^= b >>> 5);
        b -= c;
        b -= (a ^= c >>> 3);
        c -= a;
        c -= (b ^= a << 10);
        return c ^= b >>> 15;
    }

    static long mix64(long a, long b, long c) {
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >>> 43);
        c -= a;
        c -= (b ^= a << 9);
        a -= b;
        a -= (c ^= b >>> 8);
        b -= c;
        b -= (a ^= c >>> 38);
        c -= a;
        c -= (b ^= a << 23);
        a -= b;
        a -= (c ^= b >>> 5);
        b -= c;
        b -= (a ^= c >>> 35);
        c -= a;
        c -= (b ^= a << 49);
        a -= b;
        a -= (c ^= b >>> 11);
        b -= c;
        b -= (a ^= c >>> 12);
        c -= a;
        c -= (b ^= a << 18);
        return c ^= b >>> 22;
    }
}

