/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.collect.AbstractMapEntry;
import com.google.appengine.repackaged.com.google.common.collect.ForwardingMap;
import com.google.appengine.repackaged.com.google.common.collect.Iterators;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@GwtCompatible
final class WellBehavedMap<K, V>
extends ForwardingMap<K, V> {
    private final Map<K, V> delegate;
    private Set<Map.Entry<K, V>> entrySet;

    private WellBehavedMap(Map<K, V> delegate) {
        this.delegate = delegate;
    }

    static <K, V> WellBehavedMap<K, V> wrap(Map<K, V> delegate) {
        return new WellBehavedMap<K, V>(delegate);
    }

    @Override
    protected Map<K, V> delegate() {
        return this.delegate;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> es = this.entrySet;
        if (es != null) {
            return es;
        }
        this.entrySet = new EntrySet();
        return this.entrySet;
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return WellBehavedMap.this.delegate.size();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return Iterators.transform(WellBehavedMap.this.keySet().iterator(), new Function<K, Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> apply(final K key) {
                    return new AbstractMapEntry<K, V>(){

                        @Override
                        public K getKey() {
                            return key;
                        }

                        @Override
                        public V getValue() {
                            return WellBehavedMap.this.get(key);
                        }

                        @Override
                        public V setValue(V value) {
                            return WellBehavedMap.this.put(key, value);
                        }
                    };
                }
            });
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object targetKey = entry.getKey();
            Object targetValue = entry.getValue();
            if (!WellBehavedMap.this.containsKey(targetKey)) {
                return false;
            }
            return Objects.equal(WellBehavedMap.this.get(targetKey), targetValue);
        }

        @Override
        public boolean remove(Object o) {
            if (this.contains(o)) {
                Map.Entry entry = (Map.Entry)o;
                WellBehavedMap.this.remove(entry.getKey());
                return true;
            }
            return false;
        }
    }
}

