/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.Field;
import com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.api.search.checkers.FieldChecker;
import com.google.apphosting.api.search.DocumentPb;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Schema {
    private final Map<String, List<Field.FieldType>> fieldMap;

    private Schema(Builder builder) {
        this.fieldMap = Collections.unmodifiableMap(builder.fieldMap);
    }

    public Set<String> getFieldNames() {
        return this.fieldMap.keySet();
    }

    public List<Field.FieldType> getFieldTypes(String fieldName) {
        return Collections.unmodifiableList(this.fieldMap.get(fieldName));
    }

    public String toString() {
        return String.format("Schema{fieldMap: %s}", this.fieldMap);
    }

    static Schema createSchema(SearchServicePb.IndexMetadata metadata) {
        if (metadata.getFieldCount() == 0) {
            return null;
        }
        HashMap fieldMap = new HashMap();
        Builder builder = Schema.newBuilder();
        for (DocumentPb.FieldTypes fieldTypes : metadata.getFieldList()) {
            String fieldName = fieldTypes.getName();
            block8: for (DocumentPb.FieldValue.ContentType type : fieldTypes.getTypeList()) {
                switch (type) {
                    case TEXT: {
                        builder.addTypedField(fieldName, Field.FieldType.TEXT);
                        continue block8;
                    }
                    case HTML: {
                        builder.addTypedField(fieldName, Field.FieldType.HTML);
                        continue block8;
                    }
                    case ATOM: {
                        builder.addTypedField(fieldName, Field.FieldType.ATOM);
                        continue block8;
                    }
                    case DATE: {
                        builder.addTypedField(fieldName, Field.FieldType.DATE);
                        continue block8;
                    }
                    case NUMBER: {
                        builder.addTypedField(fieldName, Field.FieldType.NUMBER);
                        continue block8;
                    }
                }
                throw new IllegalArgumentException("Unsupported field type " + type);
            }
        }
        return builder.build();
    }

    public int hashCode() {
        return ((Object)this.fieldMap).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return ((Object)this.fieldMap).equals(((Schema)obj).fieldMap);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, List<Field.FieldType>> fieldMap = new HashMap<String, List<Field.FieldType>>();

        protected Builder() {
        }

        public Builder addTypedField(String fieldName, Field.FieldType fieldType) {
            FieldChecker.checkFieldName(fieldName);
            List<Field.FieldType> types = this.fieldMap.get(fieldName);
            if (types == null) {
                types = new ArrayList<Field.FieldType>();
                this.fieldMap.put(fieldName, types);
            }
            types.add(fieldType);
            return this;
        }

        public Schema build() {
            return new Schema(this);
        }
    }
}

