/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import java.util.Iterator;
import java.util.LinkedList;

public final class Util {
    private Util() {
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean equalObjects(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static <T> T defaultIfNull(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static <T> String iterableToString(Iterable<T> objects, int limit) {
        StringBuilder builder = new StringBuilder().append("[");
        String sep = "";
        int head = limit <= 0 ? Integer.MAX_VALUE : (limit + 1) / 2;
        int tail = limit <= 0 ? 0 : limit - head;
        Iterator<T> iter = objects.iterator();
        while (iter.hasNext() && --head >= 0) {
            builder.append(sep).append(iter.next().toString());
            sep = ", ";
        }
        LinkedList<T> tailMembers = new LinkedList<T>();
        int seen = 0;
        while (iter.hasNext()) {
            tailMembers.add(iter.next());
            if (++seen <= tail) continue;
            tailMembers.removeFirst();
        }
        if (seen > tail) {
            builder.append(", ...");
        }
        for (Object o : tailMembers) {
            builder.append(sep).append(o.toString());
            sep = ", ";
        }
        return builder.append("]").toString();
    }

    public static <T> String iterableFieldToString(String fieldName, Iterable<T> objects) {
        if (!objects.iterator().hasNext()) {
            return "";
        }
        return String.format(", %s=%s", fieldName, Util.iterableToString(objects, 0));
    }

    public static String fieldToString(String name, Object value) {
        return Util.fieldToString(name, value, false);
    }

    public static String fieldToString(String name, Object value, boolean firstParameter) {
        if (value == null) {
            return "";
        }
        if (firstParameter) {
            return String.format("%s=%s", name, value);
        }
        return String.format(", %s=%s", name, value);
    }
}

