/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base.genfiles;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.base.Charsets;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.X;
import java.io.Serializable;

@GoogleInternal
public final class ByteArray
implements Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] list;
    private int length;

    @Deprecated
    public ByteArray() {
        this.list = new byte[4];
        this.length = 0;
    }

    @Deprecated
    public ByteArray(int capacity) {
        this.list = new byte[capacity];
        this.length = 0;
    }

    public ByteArray(byte[] source, int start, int num) {
        X.assertTrue(num >= 0);
        this.list = new byte[num];
        this.length = num;
        System.arraycopy(source, start, this.list, 0, num);
    }

    @Deprecated
    private ByteArray(byte[] array, int arrayLength) {
        this.list = array;
        this.length = arrayLength;
    }

    @Deprecated
    public static ByteArray newInstance(byte ... array) {
        Preconditions.checkNotNull(array);
        return new ByteArray(array, array.length);
    }

    @Deprecated
    public static ByteArray newInstance(byte[] array, int length) {
        Preconditions.checkNotNull(array);
        Preconditions.checkArgument(length >= 0 && length <= array.length);
        return new ByteArray(array, length);
    }

    public int size() {
        return this.length;
    }

    public byte get(int i) {
        X.assertTrue(i >= 0 && i < this.length);
        return this.list[i];
    }

    public void set(int i, byte x) {
        X.assertTrue(i >= 0 && i < this.length);
        this.list[i] = x;
    }

    public void add(byte x) {
        if (this.length >= this.list.length) {
            this.ensureCapacity(this.length + 1);
        }
        this.list[this.length++] = x;
    }

    public void add(byte[] source, int start, int num) {
        if (this.length + num > this.list.length) {
            this.ensureCapacity(this.length + num);
        }
        System.arraycopy(source, start, this.list, this.length, num);
        this.length += num;
    }

    public void addArray(ByteArray other) {
        this.add(other.rep(), 0, other.size());
    }

    public void clear() {
        this.length = 0;
    }

    public void removeLast() {
        X.assertTrue(this.length > 0);
        --this.length;
    }

    public byte pop() {
        X.assertTrue(this.length > 0);
        return this.list[--this.length];
    }

    public void removeFast(int i) {
        X.assertTrue(i >= 0 && i < this.length);
        this.list[i] = this.list[this.length - 1];
        this.removeLast();
    }

    public int indexOf(byte element) {
        for (int i = 0; i < this.length; ++i) {
            if (this.list[i] != element) continue;
            return i;
        }
        return -1;
    }

    public void ensureCapacity(int n) {
        if (this.list.length < n) {
            int newSize = this.list.length * 2;
            if (newSize < n) {
                newSize = n;
            }
            byte[] copy = new byte[newSize];
            System.arraycopy(this.list, 0, copy, 0, this.length);
            this.list = copy;
        }
    }

    public byte[] rep() {
        return this.list;
    }

    public void resize(int n) {
        X.assertTrue(n >= 0);
        this.ensureCapacity(n);
        this.length = n;
    }

    public void trimToSize() {
        if (this.list.length != this.length) {
            this.list = this.toArray();
        }
    }

    public void swap(ByteArray other) {
        int tmpLength = this.length;
        this.length = other.length;
        other.length = tmpLength;
        byte[] tmpList = this.list;
        this.list = other.list;
        other.list = tmpList;
    }

    public byte[] toArray() {
        byte[] copy = new byte[this.length];
        System.arraycopy(this.list, 0, copy, 0, this.length);
        return copy;
    }

    public byte[] subArray(int start, int len) {
        X.assertTrue(start >= 0);
        X.assertTrue(start + len <= this.length);
        byte[] copy = new byte[len];
        System.arraycopy(this.list, start, copy, 0, len);
        return copy;
    }

    public void copy(byte[] dest, int len, int srcPos, int destPos) {
        X.assertTrue(srcPos >= 0);
        X.assertTrue(destPos >= 0);
        X.assertTrue(len >= 0);
        X.assertTrue(srcPos + len <= this.length);
        X.assertTrue(destPos + len <= dest.length);
        System.arraycopy(this.list, srcPos, dest, destPos, len);
    }

    public final void addUTF(String str) {
        int originalLength = this.length;
        byte[] utf8Bytes = str.getBytes(Charsets.UTF_8);
        this.resize(this.length + utf8Bytes.length);
        for (int i = 0; i < utf8Bytes.length; ++i) {
            this.list[originalLength + i] = utf8Bytes[i];
        }
    }
}

