/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.checkers;

import com.google.appengine.api.search.DateUtil;
import com.google.appengine.api.search.ExpressionTreeBuilder;
import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.GeoPointChecker;
import com.google.appengine.api.search.checkers.Preconditions;
import com.google.appengine.api.search.checkers.SearchApiLimits;
import com.google.appengine.repackaged.org.antlr.runtime.RecognitionException;
import com.google.apphosting.api.AppEngineInternal;
import com.google.apphosting.api.search.DocumentPb;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Locale;

@AppEngineInternal
public final class FieldChecker {
    @Deprecated
    public static final int MAXIMUM_NAME_LENGTH = 500;
    @Deprecated
    public static final int MAXIMUM_TEXT_LENGTH = 0x100000;
    @Deprecated
    public static final int MAXIMUM_ATOM_LENGTH = 500;
    @Deprecated
    public static final float MAX_NUMBER_VALUE = 2.1474836E9f;
    @Deprecated
    public static final float MIN_NUMBER_VALUE = -2.1474836E9f;
    @Deprecated
    public static final String FIELD_NAME_PATTERN = "^[A-Za-z][A-Za-z0-9_]*$";
    @Deprecated
    public static final Date MAX_DATE = DateUtil.getEpochPlusDays(Integer.MAX_VALUE, 86399999);
    @Deprecated
    public static final Date MIN_DATE = DateUtil.getEpochPlusDays(Integer.MIN_VALUE, 0);

    public static String checkFieldName(String name) {
        return FieldChecker.checkFieldName(name, "field name");
    }

    public static String checkFieldName(String name, String fieldName) {
        Preconditions.checkArgument(name != null, "%s cannot be null", fieldName);
        Preconditions.checkArgument(!Util.isNullOrEmpty(name), "%s cannot be null or empty", fieldName);
        Preconditions.checkArgument(FieldChecker.bytesInString(name) <= 500, "%s longer than %d : %s", fieldName, 500, name);
        Preconditions.checkArgument(name.matches(FIELD_NAME_PATTERN), "%s should match pattern %s: %s", fieldName, FIELD_NAME_PATTERN, name);
        return name;
    }

    static int bytesInString(String str) {
        return str.getBytes(Charset.forName("UTF-8")).length;
    }

    static boolean nameMatchesPattern(String name) {
        return name.matches(FIELD_NAME_PATTERN);
    }

    public static String checkText(String text) {
        if (text != null) {
            Preconditions.checkArgument(FieldChecker.bytesInString(text) <= 0x100000, "Field text longer than maximum length %d", 0x100000);
        }
        return text;
    }

    public static String checkHTML(String html) {
        if (html != null) {
            Preconditions.checkArgument(FieldChecker.bytesInString(html) <= 0x100000, "html longer than maximum length %d", 0x100000);
        }
        return html;
    }

    public static String checkAtom(String atom) {
        if (atom != null) {
            Preconditions.checkArgument(FieldChecker.bytesInString(atom) <= 500, "Field atom longer than maximum length %d", 500);
        }
        return atom;
    }

    public static Double checkNumber(Double value) {
        if (value != null) {
            Preconditions.checkArgument(-2.147483648E9 <= value, String.format("number value, %f, must be greater than or equal to %f", value, Float.valueOf(-2.1474836E9f)));
            Preconditions.checkArgument(value <= 2.147483648E9, String.format("number value, %f, must be less than or equal to %f", value, Float.valueOf(2.1474836E9f)));
        }
        return value;
    }

    public static Date checkDate(Date date) throws IllegalArgumentException {
        if (date != null) {
            Preconditions.checkArgument(SearchApiLimits.MINIMUM_DATE_VALUE.compareTo(date) <= 0, String.format("date %s must be after %s", DateUtil.formatDateTime(date), DateUtil.formatDateTime(SearchApiLimits.MINIMUM_DATE_VALUE)));
            Preconditions.checkArgument(date.compareTo(SearchApiLimits.MAXIMUM_DATE_VALUE) <= 0, String.format("date %s must be before %s", DateUtil.formatDateTime(date), DateUtil.formatDateTime(SearchApiLimits.MAXIMUM_DATE_VALUE)));
        }
        return date;
    }

    public static String checkExpression(String expression) {
        Preconditions.checkNotNull(expression, "expression cannot be null");
        try {
            new ExpressionTreeBuilder().parse(expression);
        }
        catch (RecognitionException e) {
            throw new IllegalArgumentException("Unable to parse expression: " + expression);
        }
        return expression;
    }

    public static DocumentPb.Field checkValid(DocumentPb.Field field) {
        FieldChecker.checkFieldName(field.getName());
        DocumentPb.FieldValue value = field.getValue();
        switch (value.getType()) {
            case TEXT: {
                FieldChecker.checkText(value.getStringValue());
                break;
            }
            case HTML: {
                FieldChecker.checkHTML(value.getStringValue());
                break;
            }
            case DATE: {
                FieldChecker.checkDate(DateUtil.deserializeDate(value.getStringValue()));
                break;
            }
            case ATOM: {
                FieldChecker.checkAtom(value.getStringValue());
                break;
            }
            case NUMBER: {
                FieldChecker.checkNumber(Double.parseDouble(value.getStringValue()));
                break;
            }
            case GEO: {
                GeoPointChecker.checkValid(value.getGeo());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported field type " + value.getType());
            }
        }
        return field;
    }

    public static Locale parseLocale(String locale) {
        if (locale == null) {
            return null;
        }
        String[] parts = locale.split("_", 3);
        if (parts.length == 1) {
            return new Locale(parts[0]);
        }
        if (parts.length == 2) {
            return new Locale(parts[0], parts[1]);
        }
        if (parts.length == 3) {
            return new Locale(parts[0], parts[1], parts[2]);
        }
        throw new IllegalArgumentException("Cannot parse locale " + locale);
    }
}

