/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.hash;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.hash.AbstractByteHasher;
import com.google.appengine.repackaged.com.google.common.hash.AbstractStreamingHashFunction;
import com.google.appengine.repackaged.com.google.common.hash.HashCode;
import com.google.appengine.repackaged.com.google.common.hash.HashCodes;
import com.google.appengine.repackaged.com.google.common.hash.Hasher;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

final class MessageDigestHashFunction
extends AbstractStreamingHashFunction
implements Serializable {
    private final String algorithmName;
    private final int bytes;
    private static final long serialVersionUID = 0L;

    MessageDigestHashFunction(String algorithmName) {
        this.algorithmName = Preconditions.checkNotNull(algorithmName);
        this.bytes = MessageDigestHashFunction.getMessageDigestLength(algorithmName);
    }

    MessageDigestHashFunction(String algorithmName, int bytes) {
        int maxLength = MessageDigestHashFunction.getMessageDigestLength(algorithmName);
        Preconditions.checkArgument(bytes >= 4 && bytes <= maxLength, "bytes (%s) must be >= 4 and < %s", bytes, maxLength);
        this.algorithmName = Preconditions.checkNotNull(algorithmName);
        this.bytes = bytes;
    }

    @Override
    public int bits() {
        return this.bytes * 8;
    }

    private static int getMessageDigestLength(String algorithmName) {
        return MessageDigestHashFunction.getMessageDigest(algorithmName).getDigestLength();
    }

    private static MessageDigest getMessageDigest(String algorithmName) {
        try {
            return MessageDigest.getInstance(algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public Hasher newHasher() {
        return new MessageDigestHasher(MessageDigestHashFunction.getMessageDigest(this.algorithmName), this.bytes);
    }

    private static final class MessageDigestHasher
    extends AbstractByteHasher {
        private final MessageDigest digest;
        private final int bytes;
        private boolean done;

        private MessageDigestHasher(MessageDigest digest, int bytes) {
            this.digest = digest;
            this.bytes = bytes;
        }

        @Override
        protected void update(byte b) {
            this.checkNotDone();
            this.digest.update(b);
        }

        @Override
        protected void update(byte[] b) {
            this.checkNotDone();
            this.digest.update(b);
        }

        @Override
        protected void update(byte[] b, int off, int len) {
            this.checkNotDone();
            this.digest.update(b, off, len);
        }

        private void checkNotDone() {
            Preconditions.checkState(!this.done, "Cannot use Hasher after calling #hash() on it");
        }

        @Override
        public HashCode hash() {
            this.done = true;
            return this.bytes == this.digest.getDigestLength() ? HashCodes.fromBytesNoCopy(this.digest.digest()) : HashCodes.fromBytesNoCopy(Arrays.copyOf(this.digest.digest(), this.bytes));
        }
    }
}

