/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.repackaged.com.google.common.io.BaseEncoding;
import com.google.appengine.repackaged.com.google.common.io.ByteStreams;
import com.google.appengine.repackaged.com.google.common.util.Base64;
import com.google.appengine.repackaged.com.google.common.util.Base64DecoderException;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSource;
import com.google.apphosting.api.DatastorePb;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class Cursor
implements Serializable {
    static final long serialVersionUID = 3515556366838971499L;
    private DatastorePb.CompiledCursor compiledCursor;

    Cursor() {
        this.compiledCursor = new DatastorePb.CompiledCursor();
    }

    Cursor(Cursor previousCursor) {
        this(previousCursor.compiledCursor);
    }

    Cursor(DatastorePb.CompiledCursor compiledCursor) {
        this.compiledCursor = (DatastorePb.CompiledCursor)compiledCursor.clone();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.write(this.compiledCursor.toByteArray());
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.compiledCursor = Cursor.fromByteArray((byte[])ByteStreams.toByteArray((InputStream)in)).compiledCursor;
    }

    void advance(int n, PreparedQuery query) {
        if (n > 0) {
            this.compiledCursor = query.asQueryResultIterator((FetchOptions)FetchOptions.Builder.withStartCursor((Cursor)this).offset((int)n).limit((int)0)).getCursor().compiledCursor;
        } else if (n == -1 && this.compiledCursor.positionSize() == 1 && this.compiledCursor.getPosition(0).hasStartKey() && !this.compiledCursor.getPosition(0).isStartInclusive()) {
            this.compiledCursor.getPosition(0).setStartInclusive(true);
        } else if (n != 0) {
            throw new IllegalArgumentException("Unable to offset cursor by " + n + " results.");
        }
    }

    public Cursor reverse() {
        DatastorePb.CompiledCursor clone = (DatastorePb.CompiledCursor)this.compiledCursor.clone();
        for (DatastorePb.CompiledCursor.Position pos : clone.positions()) {
            pos.setStartInclusive(!pos.isStartInclusive());
        }
        return new Cursor(clone);
    }

    public String toWebSafeString() {
        return BaseEncoding.base64Url().omitPadding().encode(this.compiledCursor.toByteArray());
    }

    public static Cursor fromWebSafeString(String encodedCursor) {
        if (encodedCursor == null) {
            throw new NullPointerException("encodedCursor must not be null");
        }
        try {
            return Cursor.fromByteArray(Base64.decodeWebSafe(encodedCursor));
        }
        catch (Base64DecoderException e) {
            throw new IllegalArgumentException("Unable to decode provided cursor.", e);
        }
    }

    private static Cursor fromByteArray(byte[] bytes) {
        Cursor result = new Cursor();
        if (!result.compiledCursor.merge(new ProtocolSource(bytes))) {
            throw new IllegalArgumentException("Unable to decode provided cursor.");
        }
        return result;
    }

    DatastorePb.CompiledCursor convertToPb() {
        return this.compiledCursor;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        return this.compiledCursor.equals(((Cursor)obj).compiledCursor);
    }

    public int hashCode() {
        return this.compiledCursor.hashCode();
    }

    public String toString() {
        return this.compiledCursor.toString();
    }
}

