/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.apphosting.api.AppEngineInternal;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

@AppEngineInternal
public final class DateUtil {
    public static final int MILLISECONDS_IN_DAY = 86400000;
    private static final ThreadLocal<TimeZone> UTC_TZ = new ThreadLocal<TimeZone>(){

        @Override
        protected TimeZone initialValue() {
            return TimeZone.getTimeZone("UTC");
        }
    };
    @Deprecated
    public static final Date MAX_DATE = DateUtil.getEpochPlusDays(Integer.MAX_VALUE, 86399999);
    @Deprecated
    public static final Date MIN_DATE = DateUtil.getEpochPlusDays(Integer.MIN_VALUE, 0);
    private static final ThreadLocal<DateFormat> ISO8601_SIMPLE = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return DateUtil.getDateFormat("yyyy-MM-dd");
        }
    };
    private static final ThreadLocal<DateFormat> ISO8601_DATE_TIME_SIMPLE = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return DateUtil.getDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        }
    };
    private static final ThreadLocal<DateFormat> ISO8601_DATE_TIME_SIMPLE_ERA = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return DateUtil.getDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'G");
        }
    };

    private static DateFormat getDateFormat(String formatString) {
        SimpleDateFormat format = new SimpleDateFormat(formatString, Locale.US);
        format.setTimeZone(UTC_TZ.get());
        return format;
    }

    private DateUtil() {
    }

    private static Calendar getCalendarUTC() {
        return new GregorianCalendar(UTC_TZ.get(), Locale.US);
    }

    public static String formatDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return DateUtil.isBeforeCommonEra(date) ? ISO8601_DATE_TIME_SIMPLE_ERA.get().format(date) : ISO8601_DATE_TIME_SIMPLE.get().format(date);
    }

    private static boolean isBeforeCommonEra(Date date) {
        Calendar cal = DateUtil.getCalendarUTC();
        cal.setTime(date);
        return cal.get(0) == 0;
    }

    private static Date parseDate(String dateString) {
        ParsePosition pos = new ParsePosition(0);
        Date d = ISO8601_SIMPLE.get().parse(dateString, pos);
        if (pos.getIndex() < dateString.length()) {
            throw new IllegalArgumentException(String.format("Failed to parse date string \"%s\"", dateString));
        }
        return d;
    }

    public static String serializeDate(Date date) {
        return date == null ? "" : Long.toString(date.getTime());
    }

    public static Date deserializeDate(String date) {
        if (date == null) {
            return null;
        }
        if (date.startsWith("-") ? date.length() > 1 && date.indexOf(45, 1) >= 0 : date.indexOf(45) > 0) {
            return DateUtil.parseDate(date);
        }
        return new Date(Long.parseLong(date));
    }

    @Deprecated
    static Date truncate(Date date, int field) {
        if (14 == field) {
            return date;
        }
        Calendar cal = DateUtil.getCalendarUTC();
        cal.setTime(date);
        cal.set(14, 0);
        if (13 == field) {
            return cal.getTime();
        }
        cal.set(13, 0);
        if (12 == field) {
            return cal.getTime();
        }
        cal.set(12, 0);
        if (11 == field) {
            return cal.getTime();
        }
        cal.set(11, 0);
        if (5 == field) {
            return cal.getTime();
        }
        cal.set(5, 1);
        if (2 == field) {
            return cal.getTime();
        }
        cal.set(2, 0);
        if (1 == field) {
            return cal.getTime();
        }
        throw new IllegalArgumentException("Invalid field value " + field);
    }

    public static final Date getEpochPlusDays(int days, int milliseconds) {
        Calendar cal = DateUtil.getCalendarUTC();
        cal.setTimeInMillis(0L);
        cal.add(5, days);
        cal.add(14, milliseconds);
        return cal.getTime();
    }
}

