/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.search.Consistency;
import com.google.appengine.api.search.FutureHelper;
import com.google.appengine.api.search.GetException;
import com.google.appengine.api.search.GetIndexesRequest;
import com.google.appengine.api.search.GetResponse;
import com.google.appengine.api.search.Index;
import com.google.appengine.api.search.IndexImpl;
import com.google.appengine.api.search.IndexSpec;
import com.google.appengine.api.search.OperationResult;
import com.google.appengine.api.search.Schema;
import com.google.appengine.api.search.SearchApiHelper;
import com.google.appengine.api.search.SearchService;
import com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.api.search.StatusCode;
import com.google.appengine.api.search.checkers.Preconditions;
import com.google.appengine.api.utils.FutureWrapper;
import java.util.ArrayList;
import java.util.concurrent.Future;

class SearchServiceImpl
implements SearchService {
    private final SearchApiHelper apiHelper;
    private final String namespace;

    SearchServiceImpl(SearchApiHelper apiHelper, String namespace) {
        this.apiHelper = apiHelper;
        this.namespace = SearchServiceImpl.getAppNamespace(namespace);
    }

    @Override
    public GetResponse<Index> getIndexes(GetIndexesRequest request) {
        return FutureHelper.quietGet(this.getIndexesAsync(request));
    }

    @Override
    public GetResponse<Index> getIndexes(GetIndexesRequest.Builder builder) {
        return this.getIndexes(builder.build());
    }

    @Override
    public Future<GetResponse<Index>> getIndexesAsync(GetIndexesRequest.Builder builder) {
        return this.getIndexesAsync(builder.build());
    }

    @Override
    public Future<GetResponse<Index>> getIndexesAsync(GetIndexesRequest request) {
        SearchServicePb.ListIndexesParams.Builder paramsBuilder = request.copyToProtocolBuffer().setNamespace(this.namespace);
        SearchServicePb.ListIndexesRequest pbRequest = SearchServicePb.ListIndexesRequest.newBuilder().setParams(paramsBuilder).build();
        SearchServicePb.ListIndexesResponse.Builder responseBuilder = SearchServicePb.ListIndexesResponse.newBuilder();
        Future<SearchServicePb.ListIndexesResponse.Builder> future = this.apiHelper.makeAsyncCall("ListIndexes", pbRequest, responseBuilder);
        return new FutureWrapper<SearchServicePb.ListIndexesResponse.Builder, GetResponse<Index>>(future){

            @Override
            protected Throwable convertException(Throwable cause) {
                OperationResult result = OperationResult.convertToOperationResult(cause);
                return result == null ? cause : new GetException(result);
            }

            @Override
            protected GetResponse<Index> wrap(SearchServicePb.ListIndexesResponse.Builder key) throws Exception {
                SearchServicePb.ListIndexesResponse response = key.build();
                OperationResult operationResult = new OperationResult(response.getStatus());
                if (operationResult.getCode() != StatusCode.OK) {
                    throw new GetException(operationResult);
                }
                ArrayList<IndexImpl> indexes = new ArrayList<IndexImpl>(response.getIndexMetadataCount());
                for (SearchServicePb.IndexMetadata metadata : response.getIndexMetadataList()) {
                    SearchServicePb.IndexSpec indexSpec = metadata.getIndexSpec();
                    IndexSpec.Builder builder = IndexSpec.newBuilder().setName(indexSpec.getName()).setConsistency(Consistency.fromProto(indexSpec.getConsistency()));
                    if (indexSpec.hasNamespace()) {
                        Preconditions.checkArgument(indexSpec.getNamespace().equals(SearchServiceImpl.this.namespace), String.format("Index with incorrect namespace received '%s' != '%s'", indexSpec.getNamespace(), SearchServiceImpl.this.namespace));
                    } else if (!SearchServiceImpl.this.namespace.isEmpty()) {
                        Preconditions.checkArgument(indexSpec.getNamespace().equals(SearchServiceImpl.this.namespace), String.format("Index with incorrect namespace received '' != '%s'", SearchServiceImpl.this.namespace));
                    }
                    indexes.add(new IndexImpl(SearchServiceImpl.this.apiHelper, indexSpec.getNamespace(), builder.build(), Schema.createSchema(metadata)));
                }
                return new GetResponse<Index>(indexes);
            }
        };
    }

    @Override
    public Index getIndex(IndexSpec.Builder builder) {
        return this.getIndex(builder.build());
    }

    @Override
    public Index getIndex(IndexSpec indexSpec) {
        return new IndexImpl(this.apiHelper, this.namespace, indexSpec);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    private static String getAppNamespace(String namespaceGiven) {
        if (namespaceGiven != null) {
            return namespaceGiven;
        }
        String currentNamespace = NamespaceManager.get();
        return currentNamespace == null ? "" : currentNamespace;
    }
}

