/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.checkers;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.api.search.checkers.IndexChecker;
import com.google.appengine.api.search.checkers.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.apphosting.api.AppEngineInternal;

@AppEngineInternal
public class GetIndexesRequestChecker {
    @Deprecated
    public static final int MAXIMUM_OFFSET = 1000;
    @Deprecated
    public static final int MAXIMUM_LIMIT = 1000;
    @Deprecated
    public static final int DEFAULT_LIMIT = 20;

    public static int checkLimit(int limit) {
        Preconditions.checkArgument(limit >= 1 && limit <= 1000, String.format("The limit %d must be between 1 and %d", limit, 1000));
        return limit;
    }

    public static int checkOffset(int offset) {
        Preconditions.checkArgument(offset >= 0 && offset <= 1000, String.format("The limit %d must be between 1 and %d", offset, 1000));
        return offset;
    }

    public static String checkIndexNamePrefix(String indexNamePrefix) {
        if (Strings.isNullOrEmpty(indexNamePrefix)) {
            return indexNamePrefix;
        }
        return IndexChecker.checkName(indexNamePrefix);
    }

    public static String checkStartIndexName(String startIndexName) {
        if (Strings.isNullOrEmpty(startIndexName)) {
            return startIndexName;
        }
        return IndexChecker.checkName(startIndexName);
    }

    public static SearchServicePb.ListIndexesParams checkListIndexesParams(SearchServicePb.ListIndexesParams params) {
        if (params.hasLimit()) {
            GetIndexesRequestChecker.checkLimit(params.getLimit());
        }
        if (params.hasNamespace()) {
            NamespaceManager.validateNamespace(params.getNamespace());
        }
        if (params.hasStartIndexName()) {
            GetIndexesRequestChecker.checkStartIndexName(params.getStartIndexName());
        }
        if (params.hasIndexNamePrefix()) {
            GetIndexesRequestChecker.checkIndexNamePrefix(params.getIndexNamePrefix());
        }
        if (params.hasOffset()) {
            GetIndexesRequestChecker.checkOffset(params.getOffset());
        }
        return params;
    }
}

