/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.checkers;

import com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.api.search.checkers.CursorChecker;
import com.google.appengine.api.search.checkers.FieldChecker;
import com.google.appengine.api.search.checkers.Preconditions;
import com.google.appengine.api.search.checkers.SortExpressionChecker;
import com.google.appengine.api.search.checkers.SortOptionsChecker;
import com.google.apphosting.api.AppEngineInternal;
import java.util.List;

@AppEngineInternal
public final class QueryOptionsChecker {
    @Deprecated
    public static final int MAXIMUM_OFFSET = 1000;
    @Deprecated
    public static final int MAXIMUM_LIMIT = 1000;
    @Deprecated
    public static final int DEFAULT_LIMIT = 20;
    @Deprecated
    public static final int MAXIMUM_NUMBER_FOUND_ACCURACY = 10000;
    @Deprecated
    public static final int DEFAULT_NUMBER_FOUND_ACCURACY = 100;
    @Deprecated
    public static final int MAXIMUM_NUMBER_OF_FIELDS_TO_RETURN = 100;

    public static int checkLimit(int limit) {
        Preconditions.checkArgument(limit >= 1 && limit <= 1000, "The limit %d must be between 1 and %d", limit, 1000);
        return limit;
    }

    public static Integer checkOffset(Integer offset) {
        if (offset != null) {
            Preconditions.checkArgument(offset >= 0 && offset <= 1000, "The offset %d must be between 0 and %d", offset, 1000);
        }
        return offset;
    }

    public static int checkNumberFoundAccuracy(int numberFoundAccuracy) {
        Preconditions.checkArgument(numberFoundAccuracy >= 1 && numberFoundAccuracy <= 10000, "The number found accuracy %d must be between 1 and %d", numberFoundAccuracy, 10000);
        return numberFoundAccuracy;
    }

    public static List<String> checkFieldNames(List<String> fieldNames) {
        QueryOptionsChecker.checkNumberOfFields(fieldNames.size());
        for (String fieldName : fieldNames) {
            FieldChecker.checkFieldName(fieldName);
        }
        return fieldNames;
    }

    private static List<SearchServicePb.FieldSpec.Expression> checkExpressions(List<SearchServicePb.FieldSpec.Expression> expressions) {
        QueryOptionsChecker.checkNumberOfFields(expressions.size());
        for (SearchServicePb.FieldSpec.Expression expression : expressions) {
            FieldChecker.checkFieldName(expression.getName());
            FieldChecker.checkExpression(expression.getExpression());
        }
        return expressions;
    }

    private static void checkNumberOfFields(int numberOfFields) {
        Preconditions.checkArgument(numberOfFields <= 100, "number of fields to return %d greater than %d", numberOfFields, 100);
    }

    public static SearchServicePb.SearchParams checkValid(SearchServicePb.SearchParams params) {
        if (params.hasCursor()) {
            CursorChecker.checkCursor(params.getCursor());
        }
        QueryOptionsChecker.checkOffset(params.getOffset());
        QueryOptionsChecker.checkLimit(params.getLimit());
        if (params.hasMatchedCountAccuracy()) {
            QueryOptionsChecker.checkNumberFoundAccuracy(params.getMatchedCountAccuracy());
        }
        for (SearchServicePb.SortSpec sortSpec : params.getSortSpecList()) {
            SortExpressionChecker.checkValid(sortSpec);
        }
        if (params.hasScorerSpec()) {
            SortOptionsChecker.checkValid(params.getScorerSpec());
        }
        if (params.hasKeysOnly()) {
            Preconditions.checkArgument(params.getFieldSpec().getExpressionCount() == 0, "if IDs only is requested expression to return must be empty");
            Preconditions.checkArgument(params.getFieldSpec().getNameCount() == 0, "if IDs only is requested expression to return must be empty");
        }
        QueryOptionsChecker.checkFieldNames(params.getFieldSpec().getNameList());
        QueryOptionsChecker.checkExpressions(params.getFieldSpec().getExpressionList());
        return params;
    }
}

