/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.collect.ForwardingMap;
import com.google.appengine.repackaged.com.google.common.collect.Iterators;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.Ordering;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import javax.annotation.Nullable;

abstract class AbstractNavigableMap<K, V>
extends AbstractMap<K, V>
implements NavigableMap<K, V> {
    AbstractNavigableMap() {
    }

    @Override
    @Nullable
    public abstract V get(@Nullable Object var1);

    @Override
    @Nullable
    public Map.Entry<K, V> firstEntry() {
        return Iterators.getNext(this.entryIterator(), null);
    }

    @Override
    @Nullable
    public Map.Entry<K, V> lastEntry() {
        return Iterators.getNext(this.descendingEntryIterator(), null);
    }

    @Override
    @Nullable
    public Map.Entry<K, V> pollFirstEntry() {
        return Iterators.pollNext(this.entryIterator());
    }

    @Override
    @Nullable
    public Map.Entry<K, V> pollLastEntry() {
        return Iterators.pollNext(this.descendingEntryIterator());
    }

    @Override
    public K firstKey() {
        Map.Entry<K, V> entry = this.firstEntry();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return entry.getKey();
    }

    @Override
    public K lastKey() {
        Map.Entry<K, V> entry = this.lastEntry();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return entry.getKey();
    }

    @Override
    @Nullable
    public Map.Entry<K, V> lowerEntry(K key) {
        return this.headMap(key, false).lastEntry();
    }

    @Override
    @Nullable
    public Map.Entry<K, V> floorEntry(K key) {
        return this.headMap(key, true).lastEntry();
    }

    @Override
    @Nullable
    public Map.Entry<K, V> ceilingEntry(K key) {
        return this.tailMap(key, true).firstEntry();
    }

    @Override
    @Nullable
    public Map.Entry<K, V> higherEntry(K key) {
        return this.tailMap(key, false).firstEntry();
    }

    @Override
    public K lowerKey(K key) {
        return Maps.keyOrNull(this.lowerEntry(key));
    }

    @Override
    public K floorKey(K key) {
        return Maps.keyOrNull(this.floorEntry(key));
    }

    @Override
    public K ceilingKey(K key) {
        return Maps.keyOrNull(this.ceilingEntry(key));
    }

    @Override
    public K higherKey(K key) {
        return Maps.keyOrNull(this.higherEntry(key));
    }

    abstract Iterator<Map.Entry<K, V>> entryIterator();

    abstract Iterator<Map.Entry<K, V>> descendingEntryIterator();

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap(fromKey, true, toKey, false);
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        return this.headMap(toKey, false);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        return this.tailMap(fromKey, true);
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        return new Maps.NavigableKeySet(this);
    }

    @Override
    public Set<K> keySet() {
        return this.navigableKeySet();
    }

    @Override
    public abstract int size();

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new Maps.EntrySet<K, V>(){

            @Override
            Map<K, V> map() {
                return AbstractNavigableMap.this;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return AbstractNavigableMap.this.entryIterator();
            }
        };
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        return new DescendingMap();
    }

    private final class DescendingMap
    extends ForwardingMap<K, V>
    implements NavigableMap<K, V> {
        private DescendingMap() {
        }

        @Override
        protected NavigableMap<K, V> delegate() {
            return AbstractNavigableMap.this;
        }

        @Override
        public Comparator<? super K> comparator() {
            return Ordering.from(this.delegate().comparator()).reverse();
        }

        @Override
        public K firstKey() {
            return this.delegate().lastKey();
        }

        @Override
        public K lastKey() {
            return this.delegate().firstKey();
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K key) {
            return this.delegate().higherEntry(key);
        }

        @Override
        public K lowerKey(K key) {
            return this.delegate().higherKey(key);
        }

        @Override
        public Map.Entry<K, V> floorEntry(K key) {
            return this.delegate().ceilingEntry(key);
        }

        @Override
        public K floorKey(K key) {
            return this.delegate().ceilingKey(key);
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K key) {
            return this.delegate().floorEntry(key);
        }

        @Override
        public K ceilingKey(K key) {
            return this.delegate().floorKey(key);
        }

        @Override
        public Map.Entry<K, V> higherEntry(K key) {
            return this.delegate().lowerEntry(key);
        }

        @Override
        public K higherKey(K key) {
            return this.delegate().lowerKey(key);
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            return this.delegate().lastEntry();
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            return this.delegate().firstEntry();
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            return this.delegate().pollLastEntry();
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            return this.delegate().pollFirstEntry();
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            return this.delegate();
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            return new Maps.NavigableKeySet(this);
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return this.delegate().navigableKeySet();
        }

        @Override
        public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            return this.delegate().subMap(toKey, toInclusive, fromKey, fromInclusive).descendingMap();
        }

        @Override
        public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
            return this.delegate().tailMap(toKey, inclusive).descendingMap();
        }

        @Override
        public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
            return this.delegate().headMap(fromKey, inclusive).descendingMap();
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            return this.subMap(fromKey, true, toKey, false);
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            return this.headMap(toKey, false);
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            return this.tailMap(fromKey, true);
        }

        @Override
        public Set<K> keySet() {
            return this.navigableKeySet();
        }

        @Override
        public Collection<V> values() {
            return new ForwardingMap.StandardValues(this);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new Maps.EntrySet<K, V>(){

                @Override
                Map<K, V> map() {
                    return DescendingMap.this;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return AbstractNavigableMap.this.descendingEntryIterator();
                }
            };
        }

        @Override
        public String toString() {
            return this.standardToString();
        }
    }
}

