/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf;

import com.google.appengine.repackaged.com.google.protobuf.AbstractMutableMessageLite;
import com.google.appengine.repackaged.com.google.protobuf.CodedInputStream;
import com.google.appengine.repackaged.com.google.protobuf.CodedOutputStream;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.appengine.repackaged.com.google.protobuf.FieldSet;
import com.google.appengine.repackaged.com.google.protobuf.GeneratedMessageLite;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.MutableMessageLite;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.appengine.repackaged.com.google.protobuf.WireFormat;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class GeneratedMutableMessageLite<MessageType extends GeneratedMutableMessageLite>
extends AbstractMutableMessageLite<MessageType> {
    public Parser<MessageType> getParserForType() {
        throw new UnsupportedOperationException("This is supposed to be overridden by subclasses.");
    }

    public abstract MessageType getDefaultInstanceForType();

    @Override
    public MessageType clear() {
        this.assertMutable();
        return (MessageType)this;
    }

    protected boolean parseUnknownField(CodedInputStream input, ExtensionRegistryLite extensionRegistry, int tag) throws IOException {
        return input.skipField(tag);
    }

    static MessageLite.Builder internalCopyToBuilder(MutableMessageLite fromMessage, MessageLite toMessagePrototype) {
        MessageLite.Builder builder = toMessagePrototype.newBuilderForType();
        try {
            builder.mergeFrom(fromMessage.toByteArray());
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Failed to parse serialized bytes (should not happen)");
        }
        return builder;
    }

    protected abstract MessageLite internalImmutableDefault();

    protected static MessageLite internalImmutableDefault(String name) {
        try {
            Method defaultInstanceMethod = GeneratedMessageLite.getMethodOrDie(Class.forName(name), "getDefaultInstance", new Class[0]);
            return (MessageLite)GeneratedMessageLite.invokeOrDie(defaultInstanceMethod, null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Cannot load the corresponding immutable class. Please add necessary dependencies.");
        }
    }

    @Override
    public MessageLite immutableCopy() {
        MessageLite immutableDefaultInstance = this.internalImmutableDefault();
        if (this == this.getDefaultInstanceForType()) {
            return immutableDefaultInstance;
        }
        return GeneratedMutableMessageLite.internalCopyToBuilder(this, immutableDefaultInstance).buildPartial();
    }

    public abstract MessageType mergeFrom(MessageType var1);

    static <MessageType extends MutableMessageLite> boolean parseUnknownField(FieldSet<GeneratedMessageLite.ExtensionDescriptor> extensions, MessageType defaultInstance, CodedInputStream input, ExtensionRegistryLite extensionRegistry, int tag) throws IOException {
        int wireType = WireFormat.getTagWireType(tag);
        int fieldNumber = WireFormat.getTagFieldNumber(tag);
        GeneratedMessageLite.GeneratedExtension<MessageType, ?> extension = extensionRegistry.findLiteExtensionByNumber(defaultInstance, fieldNumber);
        boolean unknown = false;
        boolean packed = false;
        if (extension == null) {
            unknown = true;
        } else if (wireType == FieldSet.getWireFormatForFieldType(extension.descriptor.getLiteType(), false)) {
            packed = false;
        } else if (extension.descriptor.isRepeated && extension.descriptor.type.isPackable() && wireType == FieldSet.getWireFormatForFieldType(extension.descriptor.getLiteType(), true)) {
            packed = true;
        } else {
            unknown = true;
        }
        if (unknown) {
            return input.skipField(tag);
        }
        if (packed) {
            int length = input.readRawVarint32();
            int limit = input.pushLimit(length);
            if (extension.descriptor.getLiteType() == WireFormat.FieldType.ENUM) {
                while (input.getBytesUntilLimit() > 0) {
                    int rawValue = input.readEnum();
                    Object value = extension.descriptor.getEnumType().findValueByNumber(rawValue);
                    if (value == null) {
                        return true;
                    }
                    extensions.addRepeatedField(extension.descriptor, extension.singularToFieldSetType(value));
                }
            } else {
                while (input.getBytesUntilLimit() > 0) {
                    Object value = FieldSet.readPrimitiveField(input, extension.descriptor.getLiteType());
                    extensions.addRepeatedField(extension.descriptor, value);
                }
            }
            input.popLimit(limit);
        } else {
            Object value;
            switch (extension.descriptor.getLiteJavaType()) {
                case MESSAGE: {
                    MutableMessageLite message = ((MutableMessageLite)extension.messageDefaultInstance).newMessageForType();
                    if (extension.descriptor.getLiteType() == WireFormat.FieldType.GROUP) {
                        input.readGroup(extension.getNumber(), message, extensionRegistry);
                    } else {
                        input.readMessage(message, extensionRegistry);
                    }
                    value = message;
                    break;
                }
                case ENUM: {
                    int rawValue = input.readEnum();
                    value = extension.descriptor.getEnumType().findValueByNumber(rawValue);
                    if (value != null) break;
                    return true;
                }
                default: {
                    value = FieldSet.readPrimitiveField(input, extension.descriptor.getLiteType());
                }
            }
            if (extension.descriptor.isRepeated()) {
                extensions.addRepeatedField(extension.descriptor, extension.singularToFieldSetType(value));
            } else {
                extensions.setField(extension.descriptor, extension.singularToFieldSetType(value));
            }
        }
        return true;
    }

    public static abstract class ExtendableMutableMessage<MessageType extends ExtendableMutableMessage<MessageType>>
    extends GeneratedMutableMessageLite<MessageType> {
        private FieldSet<GeneratedMessageLite.ExtensionDescriptor> extensions = FieldSet.emptySet();

        protected ExtendableMutableMessage() {
        }

        void internalSetExtensionSet(FieldSet<GeneratedMessageLite.ExtensionDescriptor> extensions) {
            this.extensions = extensions;
        }

        @Override
        public MessageType clear() {
            this.assertMutable();
            this.extensions = FieldSet.emptySet();
            return (MessageType)((ExtendableMutableMessage)super.clear());
        }

        private void ensureExtensionsIsMutable() {
            if (this.extensions.isImmutable()) {
                this.extensions = this.extensions.clone();
            }
        }

        private void verifyExtensionContainingType(GeneratedMessageLite.GeneratedExtension<MessageType, ?> extension) {
            if (extension.getContainingTypeDefaultInstance() != this.getDefaultInstanceForType()) {
                throw new IllegalArgumentException("This extension is for a different message type.  Please make sure that you are not suppressing any generics type warnings.");
            }
        }

        public final <Type> boolean hasExtension(GeneratedMessageLite.GeneratedExtension<MessageType, Type> extension) {
            this.verifyExtensionContainingType(extension);
            return this.extensions.hasField(extension.descriptor);
        }

        public final <Type> int getExtensionCount(GeneratedMessageLite.GeneratedExtension<MessageType, List<Type>> extension) {
            this.verifyExtensionContainingType(extension);
            return this.extensions.getRepeatedFieldCount(extension.descriptor);
        }

        public final <Type> Type getExtension(GeneratedMessageLite.GeneratedExtension<MessageType, Type> extension) {
            this.verifyExtensionContainingType(extension);
            Object value = this.extensions.getField(extension.descriptor);
            if (value == null) {
                return extension.defaultValue;
            }
            if (extension.descriptor.isRepeated) {
                return (Type)Collections.unmodifiableList((List)extension.fromFieldSetType(value));
            }
            return (Type)extension.fromFieldSetType(value);
        }

        public final <Type> Type getExtension(GeneratedMessageLite.GeneratedExtension<MessageType, List<Type>> extension, int index) {
            this.verifyExtensionContainingType(extension);
            return (Type)extension.singularFromFieldSetType(this.extensions.getRepeatedField(extension.descriptor, index));
        }

        public final <Type extends MutableMessageLite> Type getMutableExtension(GeneratedMessageLite.GeneratedExtension<MessageType, Type> extension) {
            this.assertMutable();
            this.verifyExtensionContainingType(extension);
            this.ensureExtensionsIsMutable();
            GeneratedMessageLite.ExtensionDescriptor descriptor = extension.descriptor;
            if (descriptor.getLiteJavaType() != WireFormat.JavaType.MESSAGE) {
                throw new UnsupportedOperationException("getMutableExtension() called on a non-Message type.");
            }
            if (descriptor.isRepeated()) {
                throw new UnsupportedOperationException("getMutableExtension() called on a repeated type.");
            }
            Object value = this.extensions.getField(extension.descriptor);
            if (value == null) {
                MutableMessageLite default_instance = (MutableMessageLite)extension.defaultValue;
                MutableMessageLite message = default_instance.newMessageForType();
                this.extensions.setField(extension.descriptor, message);
                return (Type)message;
            }
            return (Type)((MutableMessageLite)value);
        }

        public final <Type> MessageType setExtension(GeneratedMessageLite.GeneratedExtension<MessageType, Type> extension, Type value) {
            this.assertMutable();
            this.verifyExtensionContainingType(extension);
            this.ensureExtensionsIsMutable();
            this.extensions.setField(extension.descriptor, extension.toFieldSetType(value));
            return (MessageType)this;
        }

        public final <Type> MessageType setExtension(GeneratedMessageLite.GeneratedExtension<MessageType, List<Type>> extension, int index, Type value) {
            this.assertMutable();
            this.verifyExtensionContainingType(extension);
            this.ensureExtensionsIsMutable();
            this.extensions.setRepeatedField(extension.descriptor, index, extension.singularToFieldSetType(value));
            return (MessageType)this;
        }

        public final <Type> MessageType addExtension(GeneratedMessageLite.GeneratedExtension<MessageType, List<Type>> extension, Type value) {
            this.assertMutable();
            this.verifyExtensionContainingType(extension);
            this.ensureExtensionsIsMutable();
            this.extensions.addRepeatedField(extension.descriptor, extension.singularToFieldSetType(value));
            return (MessageType)this;
        }

        public final <Type> MessageType clearExtension(GeneratedMessageLite.GeneratedExtension<MessageType, ?> extension) {
            this.assertMutable();
            this.verifyExtensionContainingType(extension);
            this.ensureExtensionsIsMutable();
            this.extensions.clearField(extension.descriptor);
            return (MessageType)this;
        }

        protected boolean extensionsAreInitialized() {
            return this.extensions.isInitialized();
        }

        @Override
        protected boolean parseUnknownField(CodedInputStream input, ExtensionRegistryLite extensionRegistry, int tag) throws IOException {
            this.ensureExtensionsIsMutable();
            return GeneratedMutableMessageLite.parseUnknownField(this.extensions, this.getDefaultInstanceForType(), input, extensionRegistry, tag);
        }

        @Override
        public MessageLite immutableCopy() {
            GeneratedMessageLite.ExtendableBuilder builder = (GeneratedMessageLite.ExtendableBuilder)ExtendableMutableMessage.internalCopyToBuilder(this, this.internalImmutableDefault());
            builder.internalSetExtensionSet(this.extensions.cloneWithAllFieldsToImmutable());
            return builder.buildPartial();
        }

        protected ExtensionWriter newExtensionWriter() {
            return new ExtensionWriter(false);
        }

        protected ExtensionWriter newMessageSetExtensionWriter() {
            return new ExtensionWriter(true);
        }

        protected int extensionsSerializedSize() {
            return this.extensions.getSerializedSize();
        }

        protected int extensionsSerializedSizeAsMessageSet() {
            return this.extensions.getMessageSetSerializedSize();
        }

        protected final void mergeExtensionFields(MessageType other) {
            this.ensureExtensionsIsMutable();
            this.extensions.mergeFrom(((ExtendableMutableMessage)other).extensions);
        }

        protected class ExtensionWriter {
            private final Iterator<Map.Entry<GeneratedMessageLite.ExtensionDescriptor, Object>> iter;
            private Map.Entry<GeneratedMessageLite.ExtensionDescriptor, Object> next;
            private final boolean messageSetWireFormat;

            private ExtensionWriter(boolean messageSetWireFormat) {
                this.iter = ExtendableMutableMessage.this.extensions.iterator();
                if (this.iter.hasNext()) {
                    this.next = this.iter.next();
                }
                this.messageSetWireFormat = messageSetWireFormat;
            }

            public void writeUntil(int end, CodedOutputStream output) throws IOException {
                while (this.next != null && this.next.getKey().getNumber() < end) {
                    GeneratedMessageLite.ExtensionDescriptor extension = this.next.getKey();
                    if (this.messageSetWireFormat && extension.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !extension.isRepeated()) {
                        output.writeMessageSetExtension(extension.getNumber(), (MessageLite)this.next.getValue());
                    } else {
                        FieldSet.writeField(extension, this.next.getValue(), output);
                    }
                    if (this.iter.hasNext()) {
                        this.next = this.iter.next();
                        continue;
                    }
                    this.next = null;
                }
            }
        }
    }
}

