/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.memcache.AsyncMemcacheService;
import com.google.appengine.api.memcache.ErrorHandlers;
import com.google.appengine.api.memcache.Expiration;
import com.google.appengine.api.memcache.InvalidValueException;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceFactory;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

class MemcacheEntityCache {
    static Logger logger = Logger.getLogger(MemcacheEntityCache.class.getName());
    private static final Level LOG_LEVEL = Level.INFO;
    static final String NAMESPACE = "__ah-datastore-l2-v1__";
    private Double rpcDeadlineSecs;
    private Expiration defaultValueExpirationTime;
    private final AsyncMemcacheService memcacheService;

    private MemcacheEntityCache() {
        this.memcacheService = MemcacheServiceFactory.getAsyncMemcacheService(NAMESPACE);
        this.memcacheService.setErrorHandler(ErrorHandlers.getConsistentLogAndContinue(Level.INFO));
    }

    MemcacheEntityCache(AsyncMemcacheService memcacheService) {
        this.memcacheService = memcacheService;
    }

    public MemcacheEntityCache rpcDeadlineSecs(double rpcDeadlineSecs) {
        Preconditions.checkArgument(rpcDeadlineSecs > 0.0, "The rpcDeadlineSecs argument must be greater than 0");
        this.rpcDeadlineSecs = rpcDeadlineSecs;
        return this;
    }

    public Double getRpcDeadlineSecs() {
        return this.rpcDeadlineSecs;
    }

    public MemcacheEntityCache defaultValueExpirationTime(Expiration defaultValueExpirationTime) {
        this.defaultValueExpirationTime = defaultValueExpirationTime;
        return this;
    }

    public Expiration getDefaultValueExpirationTime() {
        return this.defaultValueExpirationTime;
    }

    public <K> Future<Map<K, MemcacheService.IdentifiableValue>> getIdentifiable(Collection<K> keys) {
        return new GetIdentifiablesFutureWrapper(this.memcacheService.getIdentifiables(keys));
    }

    public <K> Future<Set<K>> put(Map<K, ?> values, MemcacheService.SetPolicy policy) {
        return this.put(values, policy, this.defaultValueExpirationTime);
    }

    public <K> Future<Set<K>> put(Map<K, ?> values, MemcacheService.SetPolicy policy, Expiration valueExpirationTime) {
        return this.memcacheService.putAll(values, valueExpirationTime, policy);
    }

    public <K> Future<Set<K>> putIfUntouched(Map<K, MemcacheService.CasValues> values) {
        return this.putIfUntouched(values, this.defaultValueExpirationTime);
    }

    public <K> Future<Set<K>> putIfUntouched(Map<K, MemcacheService.CasValues> values, Expiration valueExpirationTime) {
        return this.memcacheService.putIfUntouched(values, valueExpirationTime);
    }

    public static final class Builder {
        public static MemcacheEntityCache withRpcDeadlineSecs(double rpcDeadlineSecs) {
            return new MemcacheEntityCache().rpcDeadlineSecs(rpcDeadlineSecs);
        }

        public static MemcacheEntityCache withDefaultValueExpirationTime(Expiration defaultValueExpirationTime) {
            return new MemcacheEntityCache().defaultValueExpirationTime(defaultValueExpirationTime);
        }

        public static MemcacheEntityCache withDefaults() {
            return new MemcacheEntityCache();
        }

        private Builder() {
        }
    }

    private static final class GetIdentifiablesFutureWrapper<K>
    extends FutureWrapper<Map<K, MemcacheService.IdentifiableValue>, Map<K, MemcacheService.IdentifiableValue>> {
        private GetIdentifiablesFutureWrapper(Future<Map<K, MemcacheService.IdentifiableValue>> parent) {
            super(parent);
        }

        @Override
        protected Map<K, MemcacheService.IdentifiableValue> wrap(Map<K, MemcacheService.IdentifiableValue> wrapped) throws Exception {
            return wrapped;
        }

        @Override
        protected Map<K, MemcacheService.IdentifiableValue> absorbParentException(Throwable cause) throws Throwable {
            if (cause instanceof InvalidValueException) {
                logger.log(LOG_LEVEL, "Deserialization error in memcache entity cache", cause);
                return ImmutableMap.of();
            }
            throw cause;
        }

        @Override
        protected Throwable convertException(Throwable cause) {
            return cause;
        }
    }
}

